/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.ebean.typequery.agent.offline;

import java.io.File;
import java.io.IOException;
import java.lang.instrument.IllegalClassFormatException;
import org.avaje.ebean.typequery.agent.QueryBeanTransformer;
import org.avaje.ebean.typequery.agent.offline.InputStreamTransform;
import org.avaje.ebean.typequery.agent.offline.TransformationListener;

public class OfflineFileTransform {
    private final InputStreamTransform inputStreamTransform;
    private final String inDir;
    private TransformationListener listener;

    public OfflineFileTransform(QueryBeanTransformer transformer, ClassLoader classLoader, String inDir) {
        this.inputStreamTransform = new InputStreamTransform(transformer, classLoader);
        this.inDir = inDir = this.trimSlash(inDir);
    }

    public void setListener(TransformationListener v) {
        this.listener = v;
    }

    private String trimSlash(String dir) {
        if (dir.endsWith("/")) {
            return dir.substring(0, dir.length() - 1);
        }
        return dir;
    }

    public void process(String packageNames) {
        if (packageNames == null) {
            this.processPackage("", true);
            return;
        }
        String[] pkgs = packageNames.split(",");
        for (int i = 0; i < pkgs.length; ++i) {
            String pkg = pkgs[i].trim().replace('.', '/');
            boolean recurse = false;
            if (pkg.endsWith("**")) {
                recurse = true;
                pkg = pkg.substring(0, pkg.length() - 2);
            } else if (pkg.endsWith("*")) {
                recurse = true;
                pkg = pkg.substring(0, pkg.length() - 1);
            }
            pkg = this.trimSlash(pkg);
            this.processPackage(pkg, recurse);
        }
    }

    private void processPackage(String dir, boolean recurse) {
        this.inputStreamTransform.log(5, "transform> pkg: ", dir);
        String dirPath = this.inDir + "/" + dir;
        File d = new File(dirPath);
        if (!d.exists()) {
            File currentDir = new File(".");
            String m = "File not found " + dirPath + "  currentDir:" + currentDir.getAbsolutePath();
            throw new RuntimeException(m);
        }
        File[] files = d.listFiles();
        File file = null;
        try {
            for (int i = 0; i < files.length; ++i) {
                file = files[i];
                if (file.isDirectory()) {
                    if (!recurse) continue;
                    String subdir = dir + "/" + file.getName();
                    this.processPackage(subdir, true);
                    continue;
                }
                String fileName = file.getName();
                if (fileName.endsWith(".java")) {
                    System.err.println("Expecting a .class file but got " + fileName + " ... ignoring");
                    continue;
                }
                if (!fileName.endsWith(".class")) continue;
                this.transformFile(file);
            }
        }
        catch (Exception e) {
            String fileName = file == null ? "null" : file.getName();
            String m = "Error transforming file " + fileName;
            throw new RuntimeException(m, e);
        }
    }

    private void transformFile(File file) throws IOException, IllegalClassFormatException {
        String className = this.getClassName(file);
        byte[] result = this.inputStreamTransform.transform(className, file);
        if (result != null) {
            InputStreamTransform.writeBytes(result, file);
            if (this.listener != null) {
                this.listener.logEvent("Enhanced " + file);
            }
        }
    }

    private String getClassName(File file) {
        String path = file.getPath();
        path = path.substring(this.inDir.length() + 1);
        path = path.substring(0, path.length() - ".class".length());
        return path.replace('\\', '/');
    }
}

