/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.ebean.typequery.agent.offline;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.instrument.IllegalClassFormatException;
import org.avaje.ebean.typequery.agent.QueryBeanTransformer;

public class InputStreamTransform {
    private final QueryBeanTransformer transformer;
    private final ClassLoader classLoader;

    public InputStreamTransform(QueryBeanTransformer transformer, ClassLoader classLoader) {
        this.transformer = transformer;
        this.classLoader = classLoader;
    }

    public void log(int level, String msg, String extra) {
        this.transformer.log(level, msg, extra);
    }

    public byte[] transform(String className, File file) throws IOException, IllegalClassFormatException {
        try {
            return this.transform(className, new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] transform(String className, InputStream is) throws IOException, IllegalClassFormatException {
        try {
            byte[] classBytes = InputStreamTransform.readBytes(is);
            byte[] byArray = this.transformer.transform(this.classLoader, className, null, null, classBytes);
            return byArray;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public static void writeBytes(byte[] bytes, File file) throws IOException {
        InputStreamTransform.writeBytes(bytes, new FileOutputStream(file));
    }

    public static void writeBytes(byte[] bytes, OutputStream os) throws IOException {
        int len;
        BufferedOutputStream bos = new BufferedOutputStream(os);
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        byte[] buf = new byte[1028];
        while ((len = bis.read(buf, 0, buf.length)) > -1) {
            bos.write(buf, 0, len);
        }
        bos.flush();
        bos.close();
        bis.close();
    }

    public static byte[] readBytes(InputStream is) throws IOException {
        int len;
        BufferedInputStream bis = new BufferedInputStream(is);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        byte[] buf = new byte[1028];
        while ((len = bis.read(buf, 0, buf.length)) > -1) {
            baos.write(buf, 0, len);
        }
        baos.flush();
        baos.close();
        return baos.toByteArray();
    }
}

