/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.ebean.typequery.agent;

import org.avaje.ebean.typequery.agent.AlreadyEnhancedException;
import org.avaje.ebean.typequery.agent.ClassInfo;
import org.avaje.ebean.typequery.agent.Constants;
import org.avaje.ebean.typequery.agent.EnhanceContext;
import org.avaje.ebean.typequery.agent.MethodAdapter;
import org.avaje.ebean.typequery.agent.NoEnhancementRequiredException;
import org.avaje.ebean.typequery.agent.TypeQueryAddMethods;
import org.avaje.ebean.typequery.agent.TypeQueryAssocBasicConstructor;
import org.avaje.ebean.typequery.agent.TypeQueryAssocMainConstructor;
import org.avaje.ebean.typequery.agent.TypeQueryConstructorAdapter;
import org.avaje.ebean.typequery.agent.TypeQueryConstructorForAlias;
import org.avaje.ebean.typequery.agent.asm.AnnotationVisitor;
import org.avaje.ebean.typequery.agent.asm.ClassVisitor;
import org.avaje.ebean.typequery.agent.asm.ClassWriter;
import org.avaje.ebean.typequery.agent.asm.FieldVisitor;
import org.avaje.ebean.typequery.agent.asm.MethodVisitor;

public class TypeQueryClassAdapter
extends ClassVisitor
implements Constants {
    private final EnhanceContext enhanceContext;
    private boolean typeQueryRootBean;
    private String className;
    private String signature;
    private ClassInfo classInfo;

    public TypeQueryClassAdapter(ClassWriter cw, EnhanceContext enhanceContext) {
        super(327680, cw);
        this.enhanceContext = enhanceContext;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        if ((access & 0x200) != 0) {
            throw new NoEnhancementRequiredException("Not enhancing interface");
        }
        if (this.hasEntityBeanInterface(interfaces)) {
            throw new NoEnhancementRequiredException("Not enhancing EntityBean");
        }
        this.typeQueryRootBean = "org/avaje/ebean/typequery/TQRootBean".equals(superName);
        this.className = name;
        this.signature = signature;
        this.classInfo = new ClassInfo(this.enhanceContext, name);
    }

    private boolean hasEntityBeanInterface(String[] interfaces) {
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].equals("com/avaje/ebean/bean/EntityBean")) continue;
            return true;
        }
        return false;
    }

    protected String getDomainClass() {
        int posStart = this.signature.indexOf(60);
        int posEnd = this.signature.indexOf(59, posStart + 1);
        return this.signature.substring(posStart + 2, posEnd);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.classInfo.checkTypeQueryAnnotation(desc);
        return super.visitAnnotation(desc, visible);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (this.classInfo.isAlreadyEnhanced()) {
            throw new AlreadyEnhancedException(this.className);
        }
        if (this.classInfo.isTypeQueryBean()) {
            this.classInfo.addField(access, name, desc, signature);
        }
        return super.visitField(access, name, desc, signature, value);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.classInfo.isTypeQueryBean()) {
            if (this.classInfo.addMarkerAnnotation()) {
                this.addMarkerAnnotation();
            }
            if (name.equals("<init>")) {
                if (!this.typeQueryRootBean) {
                    return this.handleAssocBeanConstructor(access, name, desc, signature, exceptions);
                }
                if (this.isLog(3)) {
                    this.log("replace constructor code <init> " + desc);
                }
                if (desc.equals("(Z)V")) {
                    return new TypeQueryConstructorForAlias(this.classInfo, this.cv);
                }
                return new TypeQueryConstructorAdapter(this.classInfo, this.getDomainClass(), this.cv, desc, signature);
            }
            if (this.isLog(5)) {
                this.log("leaving method as is - " + name + " " + desc + " " + signature);
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        if (this.isLog(8)) {
            this.log("... checking method " + name + " " + desc);
        }
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        return new MethodAdapter(mv, this.enhanceContext, this.classInfo);
    }

    private MethodVisitor handleAssocBeanConstructor(int access, String name, String desc, String signature, String[] exceptions) {
        if (desc.equals("(Ljava/lang/String;Ljava/lang/Object;I)V")) {
            this.classInfo.setHasBasicConstructor();
            return new TypeQueryAssocBasicConstructor(this.classInfo, this.cv, desc, signature);
        }
        if (desc.equals("(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;I)V")) {
            this.classInfo.setHasMainConstructor();
            return new TypeQueryAssocMainConstructor(this.classInfo, this.cv, desc, signature);
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    @Override
    public void visitEnd() {
        if (this.classInfo.isTypeQueryBean()) {
            if (!this.typeQueryRootBean) {
                this.classInfo.addAssocBeanExtras(this.cv);
            }
            TypeQueryAddMethods.add(this.cv, this.classInfo, this.typeQueryRootBean);
            if (this.isLog(2)) {
                this.classInfo.log("enhanced as type query bean");
            }
        } else if (this.classInfo.isTypeQueryUser()) {
            if (this.isLog(1)) {
                this.classInfo.log("enhanced - getfield calls replaced");
            }
        } else {
            throw new NoEnhancementRequiredException("Not a type bean or caller of type beans");
        }
        super.visitEnd();
    }

    private void addMarkerAnnotation() {
        AnnotationVisitor av;
        if (this.isLog(4)) {
            this.log("... adding marker annotation");
        }
        if ((av = this.cv.visitAnnotation("Lorg/avaje/ebean/typequery/AlreadyEnhancedMarker;", true)) != null) {
            av.visitEnd();
        }
    }

    protected boolean isLog(int level) {
        return this.enhanceContext.isLog(level);
    }

    protected void log(String msg) {
        this.enhanceContext.log(this.className, msg);
    }
}

