/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.ebean.typequery.agent;

import java.io.PrintStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.Set;
import org.avaje.ebean.typequery.agent.AlreadyEnhancedException;
import org.avaje.ebean.typequery.agent.EnhanceContext;
import org.avaje.ebean.typequery.agent.NoEnhancementRequiredException;
import org.avaje.ebean.typequery.agent.TypeQueryClassAdapter;
import org.avaje.ebean.typequery.agent.asm.CLAwareClassWriter;
import org.avaje.ebean.typequery.agent.asm.ClassReader;

public class QueryBeanTransformer
implements ClassFileTransformer {
    private final EnhanceContext enhanceContext;

    public static void premain(String agentArgs, Instrumentation inst) {
        QueryBeanTransformer t = new QueryBeanTransformer(agentArgs, null, null);
        inst.addTransformer(t);
        if (t.getLogLevel() > 0) {
            System.out.println("premain loading Transformer with args:" + agentArgs);
        }
    }

    public static void agentmain(String agentArgs, Instrumentation inst) throws Exception {
        QueryBeanTransformer t = new QueryBeanTransformer(agentArgs, null, null);
        inst.addTransformer(t);
        if (t.getLogLevel() > 0) {
            System.out.println("agentmain loading Transformer with args:" + agentArgs);
        }
    }

    public QueryBeanTransformer(String agentArgs, ClassLoader classLoader, Set<String> initialPackages) {
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        this.enhanceContext = new EnhanceContext(agentArgs, classLoader, initialPackages);
    }

    public void setLogout(PrintStream logout) {
        this.enhanceContext.setLogout(logout);
    }

    public void log(int level, String msg, String extra) {
        this.enhanceContext.log(level, msg, extra);
    }

    public int getLogLevel() {
        return this.enhanceContext.getLogLevel();
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        try {
            if (this.enhanceContext.isIgnoreClass(className)) {
                this.enhanceContext.log(8, "ignore class ", className);
                return null;
            }
            this.enhanceContext.log(8, "look at ", className);
            return this.enhancement(loader, classfileBuffer);
        }
        catch (NoEnhancementRequiredException e) {
            this.log(8, "No Enhancement required ", e.getMessage());
            return null;
        }
        catch (Exception e) {
            this.enhanceContext.log(e);
            return null;
        }
    }

    private byte[] enhancement(ClassLoader classLoader, byte[] classfileBuffer) {
        ClassReader cr = new ClassReader(classfileBuffer);
        CLAwareClassWriter cw = new CLAwareClassWriter(3, classLoader);
        TypeQueryClassAdapter ca = new TypeQueryClassAdapter(cw, this.enhanceContext);
        try {
            cr.accept(ca, 8);
            if (ca.isLog(9)) {
                ca.log("... completed");
            }
            return cw.toByteArray();
        }
        catch (AlreadyEnhancedException e) {
            if (ca.isLog(1)) {
                ca.log("already enhanced");
            }
            return null;
        }
        catch (NoEnhancementRequiredException e) {
            if (ca.isLog(9)) {
                ca.log("... skipping, no enhancement required");
            }
            return null;
        }
    }
}

