/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.ebean.typequery.agent;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import org.avaje.ebean.typequery.agent.AgentManifestReader;
import org.avaje.ebean.typequery.agent.ArgParser;
import org.avaje.ebean.typequery.agent.DetectQueryBean;
import org.avaje.ebean.typequery.agent.Distill;
import org.avaje.ebean.typequery.agent.IgnoreClassHelper;

public class EnhanceContext {
    private final IgnoreClassHelper ignoreClassHelper;
    private final DetectQueryBean detectQueryBean;
    private PrintStream logout = System.out;
    private int logLevel;

    public EnhanceContext(String agentArgs, ClassLoader classLoader, Set<String> initialPackages) {
        HashMap<String, String> agentArgsMap;
        Object[] packages;
        this.detectQueryBean = Distill.convert(AgentManifestReader.read(classLoader, initialPackages));
        if (this.detectQueryBean.isEmpty()) {
            System.err.println("---------------------------------------------------------------------------------------------");
            System.err.println("QueryBean Agent: No packages containing query beans - Missing ebean.mf files? this won't work.");
            System.err.println("---------------------------------------------------------------------------------------------");
        }
        if ((packages = Distill.parsePackages((agentArgsMap = ArgParser.parse(agentArgs)).get("packages"))).length > 0) {
            String[] all = Distill.mergePackages(this.detectQueryBean.getPackages(), (String[])packages);
            this.ignoreClassHelper = new IgnoreClassHelper(all);
        } else {
            this.ignoreClassHelper = new IgnoreClassHelper(new String[0]);
        }
        String debugValue = agentArgsMap.get("debug");
        if (debugValue != null) {
            try {
                this.logLevel = Integer.parseInt(debugValue.trim());
            }
            catch (NumberFormatException e) {
                System.err.println("QueryBean Agent: debug argument [" + debugValue + "] is not an int? ignoring.");
            }
        }
        if (this.logLevel > 1) {
            this.log(1, "QueryBean Agent: entity bean packages", this.detectQueryBean.toString());
            this.log(1, "QueryBean Agent: application packages", Arrays.toString(packages));
        }
    }

    public boolean isQueryBean(String owner) {
        return this.detectQueryBean.isQueryBean(owner);
    }

    public boolean isIgnoreClass(String className) {
        return this.ignoreClassHelper.isIgnoreClass(className);
    }

    public void setLogout(PrintStream logout) {
        this.logout = logout;
    }

    public void log(int level, String msg, String extra) {
        if (this.logLevel >= level) {
            this.logout.println(msg + extra);
        }
    }

    public void log(String className, String msg) {
        if (className != null) {
            msg = "cls: " + className + "  msg: " + msg;
        }
        this.logout.println("querybean-enhance> " + msg);
    }

    public boolean isLog(int level) {
        return this.logLevel >= level;
    }

    public void log(Throwable e) {
        e.printStackTrace(this.logout);
    }

    public int getLogLevel() {
        return this.logLevel;
    }
}

