/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.ebean.typequery.agent;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;

public class CombinedTransform {
    private final ClassFileTransformer first;
    private final ClassFileTransformer second;

    public CombinedTransform(ClassFileTransformer first, ClassFileTransformer second) {
        this.first = first;
        this.second = second;
    }

    public Response transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] origBytes) throws IllegalClassFormatException {
        byte[] transformed = this.first.transform(loader, className, classBeingRedefined, protectionDomain, origBytes);
        boolean firstEnhanced = transformed != null;
        byte[] nextBytes = transformed != null ? transformed : origBytes;
        byte[] finalTransformed = this.second.transform(loader, className, classBeingRedefined, protectionDomain, nextBytes);
        if (finalTransformed != null) {
            return new Response(finalTransformed, firstEnhanced, true);
        }
        if (transformed != null) {
            return new Response(transformed, firstEnhanced, false);
        }
        return Response.NOT_TRANSFORMED;
    }

    public static class Response {
        private static final Response NOT_TRANSFORMED = new Response();
        private final byte[] classBytes;
        private final boolean first;
        private final boolean second;

        private Response() {
            this.classBytes = null;
            this.first = false;
            this.second = false;
        }

        private Response(byte[] classBytes, boolean first, boolean second) {
            this.classBytes = classBytes;
            this.first = first;
            this.second = second;
        }

        public boolean isEnhanced() {
            return this.classBytes != null;
        }

        public byte[] getClassBytes() {
            return this.classBytes;
        }

        public boolean isFirst() {
            return this.first;
        }

        public boolean isSecond() {
            return this.second;
        }
    }
}

