/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.ebean.typequery.agent;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.avaje.ebean.typequery.agent.Constants;
import org.avaje.ebean.typequery.agent.EnhanceContext;
import org.avaje.ebean.typequery.agent.FieldInfo;
import org.avaje.ebean.typequery.agent.NoEnhancementRequiredException;
import org.avaje.ebean.typequery.agent.TypeQueryAssocBasicConstructor;
import org.avaje.ebean.typequery.agent.TypeQueryAssocMainConstructor;
import org.avaje.ebean.typequery.agent.asm.ClassVisitor;

public class ClassInfo
implements Constants {
    static Set<String> entityBeanAnnotations = new HashSet<String>();
    private final EnhanceContext enhanceContext;
    private final String className;
    private boolean addedMarkerAnnotation;
    private boolean typeQueryBean;
    private boolean typeQueryUser;
    private boolean alreadyEnhanced;
    private List<FieldInfo> fields;
    private boolean hasBasicConstructor;
    private boolean hasMainConstructor;

    public ClassInfo(EnhanceContext enhanceContext, String className) {
        this.enhanceContext = enhanceContext;
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isAlreadyEnhanced() {
        return this.alreadyEnhanced;
    }

    public boolean addMarkerAnnotation() {
        if (this.addedMarkerAnnotation) {
            return false;
        }
        this.addedMarkerAnnotation = true;
        return true;
    }

    public boolean isTypeQueryBean() {
        return this.typeQueryBean;
    }

    public boolean isTypeQueryUser() {
        return this.typeQueryUser;
    }

    public void checkTypeQueryAnnotation(String desc) {
        if (this.isEntityBeanAnnotation(desc)) {
            throw new NoEnhancementRequiredException("Not enhancing entity bean");
        }
        if (this.isTypeQueryBeanAnnotation(desc)) {
            this.typeQueryBean = true;
        } else if (this.isAlreadyEnhancedAnnotation(desc)) {
            this.alreadyEnhanced = true;
        }
    }

    public void addField(int access, String name, String desc, String signature) {
        if ((access & 1) != 0) {
            if (this.fields == null) {
                this.fields = new ArrayList<FieldInfo>();
            }
            this.fields.add(new FieldInfo(this, name, desc, signature));
        }
    }

    private boolean isAlreadyEnhancedAnnotation(String desc) {
        return "Lorg/avaje/ebean/typequery/AlreadyEnhancedMarker;".equals(desc);
    }

    private boolean isTypeQueryBeanAnnotation(String desc) {
        return "Lorg/avaje/ebean/typequery/TypeQueryBean;".equals(desc);
    }

    private boolean isEntityBeanAnnotation(String desc) {
        return entityBeanAnnotations.contains(desc);
    }

    public List<FieldInfo> getFields() {
        return this.fields;
    }

    public void addGetFieldIntercept(String owner, String name) {
        if (this.isLog(4)) {
            this.log("change getfield " + owner + " name:" + name);
        }
        this.typeQueryUser = true;
    }

    public boolean isLog(int level) {
        return this.enhanceContext.isLog(level);
    }

    public void log(String msg) {
        this.enhanceContext.log(this.className, msg);
    }

    public void setHasBasicConstructor() {
        if (this.isLog(3)) {
            this.log("replace assoc bean basic constructor");
        }
        this.hasBasicConstructor = true;
    }

    public void setHasMainConstructor() {
        if (this.isLog(3)) {
            this.log("replace assoc bean main constructor");
        }
        this.hasMainConstructor = true;
    }

    public void addAssocBeanExtras(ClassVisitor cv) {
        if (this.isLog(3)) {
            String msg = "... add fields";
            if (!this.hasBasicConstructor) {
                msg = msg + ", basic constructor";
            }
            if (!this.hasMainConstructor) {
                msg = msg + ", main constructor";
            }
            this.log(msg);
        }
        if (!this.hasBasicConstructor) {
            new TypeQueryAssocBasicConstructor(this, cv, "(Ljava/lang/String;Ljava/lang/Object;I)V", "(Ljava/lang/String;TR;I)V").visitCode();
        }
        if (!this.hasMainConstructor) {
            new TypeQueryAssocMainConstructor(this, cv, "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;I)V", "(Ljava/lang/String;TR;Ljava/lang/String;I)V").visitCode();
        }
    }

    static {
        entityBeanAnnotations.add("Ljavax/persistence/Entity;");
        entityBeanAnnotations.add("Ljavax/persistence/Embeddable;");
        entityBeanAnnotations.add("Ljavax/persistence/MappedSuperclass;");
    }
}

