/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.ebean.typequery;

import com.avaje.ebean.Ebean;
import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.ExpressionList;
import com.avaje.ebean.FetchConfig;
import com.avaje.ebean.FetchPath;
import com.avaje.ebean.FutureIds;
import com.avaje.ebean.FutureList;
import com.avaje.ebean.FutureRowCount;
import com.avaje.ebean.PagedList;
import com.avaje.ebean.PersistenceContextScope;
import com.avaje.ebean.Query;
import com.avaje.ebean.QueryIterator;
import com.avaje.ebean.RawSql;
import com.avaje.ebean.Version;
import com.avaje.ebean.search.MultiMatch;
import com.avaje.ebean.search.TextCommonTerms;
import com.avaje.ebean.search.TextQueryString;
import com.avaje.ebean.search.TextSimple;
import com.avaje.ebean.text.PathProperties;
import com.avaje.ebeaninternal.server.util.ArrayStack;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.avaje.ebean.typequery.TQProperty;
import org.jetbrains.annotations.Nullable;

public abstract class TQRootBean<T, R> {
    private final Query<T> query;
    private ArrayStack<ExpressionList<T>> whereStack;
    private ArrayStack<ExpressionList<T>> textStack;
    private boolean textMode;
    private R root;

    public TQRootBean(Class<T> beanType) {
        this(beanType, Ebean.getDefaultServer());
    }

    public TQRootBean(Class<T> beanType, EbeanServer server) {
        this(server.find(beanType));
    }

    public TQRootBean(Query<T> query) {
        this.query = query;
    }

    public TQRootBean(boolean aliasDummy) {
        this.query = null;
    }

    protected void setRoot(R root) {
        this.root = root;
    }

    public Query<T> query() {
        return this.query;
    }

    public R select(String fetchProperties) {
        this.query.select(fetchProperties);
        return this.root;
    }

    @SafeVarargs
    public final R select(TQProperty<R> ... properties) {
        StringBuilder selectProps = new StringBuilder(50);
        for (int i = 0; i < properties.length; ++i) {
            if (i > 0) {
                selectProps.append(",");
            }
            selectProps.append(properties[i].propertyName());
        }
        this.query.select(selectProps.toString());
        return this.root;
    }

    public R fetch(String path) {
        this.query.fetch(path);
        return this.root;
    }

    public R fetch(String path, String fetchProperties) {
        this.query.fetch(path, fetchProperties);
        return this.root;
    }

    public R fetch(String path, String fetchProperties, FetchConfig fetchConfig) {
        this.query.fetch(path, fetchProperties, fetchConfig);
        return this.root;
    }

    public R fetch(String path, FetchConfig fetchConfig) {
        this.query.fetch(path, fetchConfig);
        return this.root;
    }

    public R apply(PathProperties pathProperties) {
        this.query.apply((FetchPath)pathProperties);
        return this.root;
    }

    public R asOf(Timestamp asOf) {
        this.query.asOf(asOf);
        return this.root;
    }

    public R asDraft() {
        this.query.asDraft();
        return this.root;
    }

    @Deprecated
    public R includeSoftDeletes() {
        this.query.setIncludeSoftDeletes();
        return this.root;
    }

    public R setIncludeSoftDeletes() {
        this.query.setIncludeSoftDeletes();
        return this.root;
    }

    public R alias(String alias) {
        this.query.alias(alias);
        return this.root;
    }

    public R setMaxRows(int maxRows) {
        this.query.setMaxRows(maxRows);
        return this.root;
    }

    public R setFirstRow(int firstRow) {
        this.query.setFirstRow(firstRow);
        return this.root;
    }

    public R setAutoTune(boolean autoTune) {
        this.query.setAutoTune(autoTune);
        return this.root;
    }

    public R setBufferFetchSizeHint(int fetchSize) {
        this.query.setBufferFetchSizeHint(fetchSize);
        return this.root;
    }

    public R setDistinct(boolean distinct) {
        this.query.setDistinct(distinct);
        return this.root;
    }

    public R setDocIndexName(String indexName) {
        this.query.setDocIndexName(indexName);
        return this.root;
    }

    public R setForUpdate(boolean forUpdate) {
        this.query.setForUpdate(forUpdate);
        return this.root;
    }

    public R setId(Object id) {
        this.query.setId(id);
        return this.root;
    }

    public R setIdIn(Object ... ids) {
        this.query.where().idIn(ids);
        return this.root;
    }

    public R setLazyLoadBatchSize(int lazyLoadBatchSize) {
        this.query.setLazyLoadBatchSize(lazyLoadBatchSize);
        return this.root;
    }

    public R setLoadBeanCache(boolean loadBeanCache) {
        this.query.setLoadBeanCache(loadBeanCache);
        return this.root;
    }

    public R setMapKey(String mapKey) {
        this.query.setMapKey(mapKey);
        return this.root;
    }

    public R setPersistenceContextScope(PersistenceContextScope scope) {
        this.query.setPersistenceContextScope(scope);
        return this.root;
    }

    public R setRawSql(RawSql rawSql) {
        this.query.setRawSql(rawSql);
        return this.root;
    }

    public R setReadOnly(boolean readOnly) {
        this.query.setReadOnly(readOnly);
        return this.root;
    }

    public R setUseCache(boolean useCache) {
        this.query.setUseCache(useCache);
        return this.root;
    }

    public R setUseDocStore(boolean useDocStore) {
        this.query.setUseDocStore(useDocStore);
        return this.root;
    }

    public R setDisableLazyLoading(boolean disableLazyLoading) {
        this.query.setDisableLazyLoading(disableLazyLoading);
        return this.root;
    }

    public R setDisableReadAuditing() {
        this.query.setDisableReadAuditing();
        return this.root;
    }

    public R setUseQueryCache(boolean useCache) {
        this.query.setUseQueryCache(useCache);
        return this.root;
    }

    public R setTimeout(int secs) {
        this.query.setTimeout(secs);
        return this.root;
    }

    public Set<String> validate() {
        return this.query.validate();
    }

    public R raw(String rawExpression) {
        this.peekExprList().raw(rawExpression);
        return this.root;
    }

    public R raw(String rawExpression, Object ... bindValues) {
        this.peekExprList().raw(rawExpression, bindValues);
        return this.root;
    }

    public R raw(String rawExpression, Object bindValue) {
        this.peekExprList().raw(rawExpression, bindValue);
        return this.root;
    }

    public R orderBy() {
        return this.root;
    }

    public R order() {
        return this.root;
    }

    public R orderBy(String orderByClause) {
        this.query.orderBy(orderByClause);
        return this.root;
    }

    public R order(String orderByClause) {
        this.query.order(orderByClause);
        return this.root;
    }

    public R or() {
        this.pushExprList((ExpressionList<T>)this.peekExprList().or());
        return this.root;
    }

    public R and() {
        this.pushExprList((ExpressionList<T>)this.peekExprList().and());
        return this.root;
    }

    public R not() {
        this.pushExprList((ExpressionList<T>)this.peekExprList().not());
        return this.root;
    }

    public R must() {
        this.pushExprList((ExpressionList<T>)this.peekExprList().must());
        return this.root;
    }

    public R mustNot() {
        return this.pushExprList((ExpressionList<T>)this.peekExprList().mustNot());
    }

    public R should() {
        return this.pushExprList((ExpressionList<T>)this.peekExprList().should());
    }

    public R endJunction() {
        if (this.textMode) {
            this.textStack.pop();
        } else {
            this.whereStack.pop();
        }
        return this.root;
    }

    public R endOr() {
        return this.endJunction();
    }

    public R endAnd() {
        return this.endJunction();
    }

    public R endNot() {
        return this.endJunction();
    }

    private R pushExprList(ExpressionList<T> list) {
        if (this.textMode) {
            this.textStack.push(list);
        } else {
            this.whereStack.push(list);
        }
        return this.root;
    }

    public R where() {
        this.textMode = false;
        return this.root;
    }

    public R text() {
        this.textMode = true;
        return this.root;
    }

    public R multiMatch(String query, MultiMatch multiMatch) {
        this.peekExprList().multiMatch(query, multiMatch);
        return this.root;
    }

    public R multiMatch(String query, String ... properties) {
        this.peekExprList().multiMatch(query, properties);
        return this.root;
    }

    public R textCommonTerms(String query, TextCommonTerms options) {
        this.peekExprList().textCommonTerms(query, options);
        return this.root;
    }

    public R textSimple(String query, TextSimple options) {
        this.peekExprList().textSimple(query, options);
        return this.root;
    }

    public R textQueryString(String query, TextQueryString options) {
        this.peekExprList().textQueryString(query, options);
        return this.root;
    }

    @Nullable
    public T findUnique() {
        return (T)this.query.findUnique();
    }

    public List<T> findList() {
        return this.query.findList();
    }

    public <A> List<A> findIds() {
        return this.query.findIds();
    }

    public <K> Map<K, T> findMap() {
        return this.query.findMap();
    }

    public QueryIterator<T> findIterate() {
        return this.query.findIterate();
    }

    public <A> List<A> findSingleAttributeList() {
        return this.query.findSingleAttributeList();
    }

    public void findEach(Consumer<T> consumer) {
        this.query.findEach(consumer);
    }

    public void findEachWhile(Predicate<T> consumer) {
        this.query.findEachWhile(consumer);
    }

    public List<Version<T>> findVersions() {
        return this.query.findVersions();
    }

    public List<Version<T>> findVersionsBetween(Timestamp start, Timestamp end) {
        return this.query.findVersionsBetween(start, end);
    }

    public int findCount() {
        return this.query.findCount();
    }

    public FutureRowCount<T> findFutureCount() {
        return this.query.findFutureCount();
    }

    public FutureIds<T> findFutureIds() {
        return this.query.findFutureIds();
    }

    public FutureList<T> findFutureList() {
        return this.query.findFutureList();
    }

    public PagedList<T> findPagedList() {
        return this.query.findPagedList();
    }

    public int delete() {
        return this.query.delete();
    }

    public String getGeneratedSql() {
        return this.query.getGeneratedSql();
    }

    public Class<T> getBeanType() {
        return this.query.getBeanType();
    }

    public ExpressionList<T> getExpressionList() {
        return this.query.where();
    }

    protected ExpressionList<T> peekExprList() {
        if (this.textMode) {
            return this._peekText();
        }
        if (this.whereStack == null) {
            this.whereStack = new ArrayStack();
            this.whereStack.push((Object)this.query.where());
        }
        return (ExpressionList)this.whereStack.peek();
    }

    protected ExpressionList<T> _peekText() {
        if (this.textStack == null) {
            this.textStack = new ArrayStack();
            this.textStack.push((Object)this.query.text());
        }
        return (ExpressionList)this.textStack.peek();
    }
}

