/*
 * Decompiled with CFR 0.152.
 */
package org.avaje.ebeanorm.hazelcast;

import com.avaje.ebean.BackgroundExecutor;
import com.avaje.ebean.cache.ServerCache;
import com.avaje.ebean.cache.ServerCacheFactory;
import com.avaje.ebean.cache.ServerCacheOptions;
import com.avaje.ebean.cache.ServerCacheType;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebeaninternal.server.cache.DefaultServerCache;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.avaje.ebeanorm.hazelcast.HzCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HzCacheFactory
implements ServerCacheFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.avaje.ebean.cache.HzCacheFactory");
    private final ConcurrentHashMap<String, HzQueryCache> queryCaches;
    private final HazelcastInstance instance;
    private final ITopic<String> queryCacheInvalidation;
    private final BackgroundExecutor executor;

    public HzCacheFactory(ServerConfig serverConfig, BackgroundExecutor executor) {
        Object hazelcastInstance;
        this.executor = executor;
        this.queryCaches = new ConcurrentHashMap();
        if (System.getProperty("hazelcast.logging.type") == null) {
            System.setProperty("hazelcast.logging.type", "slf4j");
        }
        this.instance = (hazelcastInstance = serverConfig.getServiceObject("hazelcast")) != null ? (HazelcastInstance)hazelcastInstance : this.createInstance(serverConfig);
        this.queryCacheInvalidation = this.instance.getReliableTopic("queryCacheInvalidation");
        this.queryCacheInvalidation.addMessageListener((MessageListener)new MessageListener<String>(){

            public void onMessage(Message<String> message) {
                HzCacheFactory.this.processInvalidation((String)message.getMessageObject());
            }
        });
    }

    private HazelcastInstance createInstance(ServerConfig serverConfig) {
        Object configuration = serverConfig.getServiceObject("hazelcastConfiguration");
        if (configuration != null) {
            if (configuration instanceof ClientConfig) {
                return HazelcastClient.newHazelcastClient((ClientConfig)((ClientConfig)configuration));
            }
            if (configuration instanceof Config) {
                return Hazelcast.newHazelcastInstance((Config)((Config)configuration));
            }
            throw new IllegalArgumentException("Invalid Hazelcast configuration type " + configuration.getClass());
        }
        if (this.isServerMode(serverConfig.getProperties())) {
            return Hazelcast.newHazelcastInstance();
        }
        return HazelcastClient.newHazelcastClient();
    }

    private boolean isServerMode(Properties properties) {
        return properties != null && properties.getProperty("ebean.hazelcast.servermode", "").equals("true");
    }

    public ServerCache createCache(ServerCacheType type, String key, ServerCacheOptions options) {
        switch (type) {
            case QUERY: {
                return this.createQueryCache(key, options);
            }
        }
        return this.createNormalCache(type, key, options);
    }

    private ServerCache createNormalCache(ServerCacheType type, String key, ServerCacheOptions options) {
        String fullName = type.name() + "-" + key;
        logger.debug("get cache [{}]", (Object)fullName);
        IMap map = this.instance.getMap(fullName);
        return new HzCache((IMap<Object, Object>)map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerCache createQueryCache(String key, ServerCacheOptions options) {
        HzCacheFactory hzCacheFactory = this;
        synchronized (hzCacheFactory) {
            HzQueryCache cache = this.queryCaches.get(key);
            if (cache == null) {
                logger.debug("create query cache [{}]", (Object)key);
                cache = new HzQueryCache(key, options);
                cache.periodicTrim(this.executor);
                this.queryCaches.put(key, cache);
            }
            return cache;
        }
    }

    private void sendInvalidation(String key) {
        this.queryCacheInvalidation.publish((Object)key);
    }

    private void processInvalidation(String cacheName) {
        HzQueryCache cache = this.queryCaches.get(cacheName);
        if (cache != null) {
            cache.invalidate();
        }
    }

    private class HzQueryCache
    extends DefaultServerCache {
        HzQueryCache(String name, ServerCacheOptions options) {
            super(name, options);
        }

        public void clear() {
            super.clear();
            HzCacheFactory.this.sendInvalidation(this.name);
        }

        private void invalidate() {
            super.clear();
        }
    }
}

