/*
 * Decompiled with CFR 0.152.
 */
package avail.plugin;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0000H\u0002J\u0011\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u0003H\u0016J\u0010\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0006H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0011\u0010\r\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0011\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u0011\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\bR\u0011\u0010\u0013\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lavail/plugin/AvailStdLibVersion;", "", "versionString", "", "(Ljava/lang/String;)V", "artifactMajor", "", "getArtifactMajor", "()I", "artifactMinor", "getArtifactMinor", "artifactRevision", "getArtifactRevision", "libraryMajor", "getLibraryMajor", "libraryMinor", "getLibraryMinor", "libraryRevision", "getLibraryRevision", "version", "getVersion", "()Ljava/lang/String;", "compareArtifactVersion", "other", "compareTo", "toString", "verAsString", "ver", "avail-plugin"})
public final class AvailStdLibVersion
implements Comparable<AvailStdLibVersion> {
    private final int artifactMajor;
    private final int artifactMinor;
    private final int artifactRevision;
    private final int libraryMajor;
    private final int libraryMinor;
    private final int libraryRevision;
    @NotNull
    private final String version;

    public AvailStdLibVersion(@NotNull String versionString) {
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        String[] stringArray = new String[]{"-"};
        List versionParts = StringsKt.split$default((CharSequence)StringsKt.removeSuffix((String)versionString, (CharSequence)"-SNAPSHOT"), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (versionParts.size() == 1) {
            this.artifactMajor = 0;
            this.artifactMinor = 0;
            this.artifactRevision = 0;
            String[] stringArray2 = new String[]{"."};
            List libraryParts = StringsKt.split$default((CharSequence)((CharSequence)versionParts.get(0)), (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            this.libraryMajor = Integer.parseInt((String)libraryParts.get(0));
            this.libraryMinor = Integer.parseInt((String)libraryParts.get(1));
            this.libraryRevision = Integer.parseInt((String)libraryParts.get(2));
        } else {
            String[] stringArray3 = new String[]{"."};
            List artifactParts = StringsKt.split$default((CharSequence)((CharSequence)versionParts.get(0)), (String[])stringArray3, (boolean)false, (int)0, (int)6, null);
            this.artifactMajor = Integer.parseInt((String)artifactParts.get(0));
            this.artifactMinor = Integer.parseInt((String)artifactParts.get(1));
            this.artifactRevision = Integer.parseInt((String)artifactParts.get(2));
            String[] stringArray4 = new String[]{"."};
            List libraryParts = StringsKt.split$default((CharSequence)((CharSequence)versionParts.get(1)), (String[])stringArray4, (boolean)false, (int)0, (int)6, null);
            this.libraryMajor = Integer.parseInt((String)libraryParts.get(0));
            this.libraryMinor = Integer.parseInt((String)libraryParts.get(1));
            this.libraryRevision = Integer.parseInt((String)libraryParts.get(2));
        }
        this.version = this.artifactMajor + "." + this.verAsString(this.artifactMinor) + "." + this.verAsString(this.artifactRevision) + "-\"" + this.libraryMajor + "." + this.verAsString(this.libraryMinor) + "." + this.verAsString(this.libraryRevision) + "\"";
    }

    public final int getArtifactMajor() {
        return this.artifactMajor;
    }

    public final int getArtifactMinor() {
        return this.artifactMinor;
    }

    public final int getArtifactRevision() {
        return this.artifactRevision;
    }

    public final int getLibraryMajor() {
        return this.libraryMajor;
    }

    public final int getLibraryMinor() {
        return this.libraryMinor;
    }

    public final int getLibraryRevision() {
        return this.libraryRevision;
    }

    private final String verAsString(int ver) {
        return ver < 10 ? "0" + ver : String.valueOf(ver);
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @NotNull
    public String toString() {
        return this.version;
    }

    private final int compareArtifactVersion(AvailStdLibVersion other) {
        return this.artifactMajor > other.artifactMajor ? 1 : (this.artifactMajor < other.artifactMajor ? -1 : (this.artifactMinor > other.artifactMinor ? 1 : (this.artifactMinor < other.artifactMinor ? -1 : (this.artifactRevision > other.artifactRevision ? 1 : (this.artifactRevision < other.artifactRevision ? -1 : 0)))));
    }

    @Override
    public int compareTo(@NotNull AvailStdLibVersion other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.libraryMajor > other.libraryMajor ? 1 : (this.libraryMajor < other.libraryMajor ? -1 : (this.libraryMinor > other.libraryMinor ? 1 : (this.libraryMinor < other.libraryMinor ? -1 : (this.libraryRevision > other.libraryRevision ? 1 : (this.libraryRevision < other.libraryRevision ? -1 : this.compareArtifactVersion(other))))));
    }
}

