/*
 * Decompiled with CFR 0.152.
 */
package avail.plugin;

import avail.plugin.AvailAnvilTask;
import avail.plugin.AvailExtension;
import avail.plugin.AvailLibraryDependency;
import avail.plugin.AvailPlugin;
import avail.plugin.PackageAvailArtifactTask;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.availlang.artifact.AvailArtifactBuildPlan;
import org.availlang.artifact.AvailArtifactMetadata;
import org.availlang.artifact.environment.AvailEnvironment;
import org.availlang.artifact.environment.location.AvailLibraries;
import org.availlang.artifact.environment.location.AvailLocation;
import org.availlang.artifact.environment.location.Scheme;
import org.availlang.artifact.environment.project.AvailProject;
import org.availlang.artifact.manifest.AvailRootManifest;
import org.availlang.artifact.roots.AvailRoot;
import org.availlang.artifact.roots.CreateAvailRoot;
import org.gradle.api.DefaultTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\f"}, d2={"Lavail/plugin/AvailPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "target", "downloadLib", "Lorg/availlang/artifact/AvailArtifactMetadata;", "artifact", "Lorg/gradle/api/artifacts/ResolvedArtifact;", "Companion", "avail-plugin"})
public final class AvailPlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String AVAIL_DEP_GRP = "org.availlang";
    @NotNull
    public static final String AVAIL_STDLIB_DEP_ARTIFACT_NAME = "avail-stdlib";
    @NotNull
    public static final String AVAIL_LIBRARY = "availLibrary";
    @NotNull
    public static final String AVAIL = "avail";

    public AvailPlugin() {
        AvailEnvironment.INSTANCE.optionallyCreateAvailUserHome();
    }

    public void apply(@NotNull Project target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        ConfigurationContainer $this$apply_u24lambda_u242 = target.getConfigurations();
        boolean bl = false;
        Object object = $this$apply_u24lambda_u242.create(AVAIL_LIBRARY);
        Configuration $this$apply_u24lambda_u242_u24lambda_u240 = (Configuration)object;
        boolean bl2 = false;
        $this$apply_u24lambda_u242_u24lambda_u240.setTransitive(false);
        $this$apply_u24lambda_u242_u24lambda_u240.setVisible(false);
        $this$apply_u24lambda_u242_u24lambda_u240.setDescription("Config for acquiring published Avail library dependencies");
        object = $this$apply_u24lambda_u242.create(AVAIL);
        Configuration $this$apply_u24lambda_u242_u24lambda_u241 = (Configuration)object;
        boolean bl3 = false;
        $this$apply_u24lambda_u242_u24lambda_u241.setTransitive(false);
        $this$apply_u24lambda_u242_u24lambda_u241.setVisible(false);
        $this$apply_u24lambda_u242_u24lambda_u241.setDescription("Config for acquiring Avail libraries from maven");
        Configuration cfr_ignored_0 = (Configuration)$this$apply_u24lambda_u242.create("__internalAvailAnvil");
        Object[] objectArray = new Object[]{target, this};
        AvailExtension extension = (AvailExtension)target.getExtensions().create(AVAIL, AvailExtension.class, objectArray);
        target.getTasks().register("downloadAvailLibraries", DefaultTask.class, arg_0 -> AvailPlugin.apply$lambda$3((Function1)new Function1<DefaultTask, Unit>(target, this){
            final /* synthetic */ Project $target;
            final /* synthetic */ AvailPlugin this$0;
            {
                this.$target = $target;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(DefaultTask $this$register) {
                StringBuilder stringBuilder;
                $this$register.setDescription("Downloads all `avail` libraries in the `dependencies` block to `~/.avail/libraries` making them available for Avail project use. This is automatically run on Gradle refresh. Libraries are re-downloaded and overwritten with each run.");
                Object object = this.$target;
                AvailPlugin availPlugin = this.this$0;
                StringBuilder $this$invoke_u24lambda_u243 = stringBuilder = new StringBuilder();
                boolean bl = false;
                Set set = object.getConfigurations().getByName("avail").getResolvedConfiguration().getResolvedArtifacts();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"target.configurations.ge\u2026uration.resolvedArtifacts");
                Iterable $this$forEach$iv = set;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    ResolvedArtifact it = (ResolvedArtifact)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    AvailArtifactMetadata metadata = AvailPlugin.access$downloadLib(availPlugin, it);
                    boolean bl3 = false;
                    $this$invoke_u24lambda_u243.append("Downloaded: ");
                    $this$invoke_u24lambda_u243.append(metadata.getLocation().getPath());
                    Iterable $this$forEach$iv2 = metadata.getManifest().getRoots().values();
                    boolean $i$f$forEach2 = false;
                    for (T element$iv2 : $this$forEach$iv2) {
                        AvailRootManifest m = (AvailRootManifest)element$iv2;
                        boolean bl4 = false;
                        $this$invoke_u24lambda_u243.append("\n\tRoot name in jar: '");
                        $this$invoke_u24lambda_u243.append(m.getName());
                        $this$invoke_u24lambda_u243.append("'\n\t\t");
                        $this$invoke_u24lambda_u243.append(m.getDescription());
                    }
                }
                String string = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
                object = string;
                System.out.println(object);
            }
        }, arg_0));
        target.getTasks().register("setupProject", DefaultTask.class, arg_0 -> AvailPlugin.apply$lambda$4((Function1)new Function1<DefaultTask, Unit>(target, extension, this){
            final /* synthetic */ Project $target;
            final /* synthetic */ AvailExtension $extension;
            final /* synthetic */ AvailPlugin this$0;
            {
                this.$target = $target;
                this.$extension = $extension;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(DefaultTask $this$register) {
                void $this$forEach$iv;
                $this$register.setGroup("avail");
                $this$register.setDescription("Initialize the Avail Project. This sets up the project according to the configuration in the `avail` extension block. At the end of this task, all root initializers (lambdas) that were added will be run.");
                Object[] objectArray = new Object[]{"downloadAvailLibraries"};
                $this$register.dependsOn(objectArray);
                Configuration availLibConfig = this.$target.getConfigurations().getByName("availLibrary");
                Iterable iterable = this.$extension.getRootDependencies$avail_plugin();
                Project project = this.$target;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    AvailLibraryDependency it = (AvailLibraryDependency)element$iv;
                    boolean bl = false;
                    Dependency dependency = it.dependency$avail_plugin(project);
                    availLibConfig.getDependencies().add((Object)dependency);
                }
                $this$register.doLast(arg_0 -> apply.3.invoke$lambda$1((Function1)new Function1<Task, Unit>(this.$extension, availLibConfig, this.this$0){
                    final /* synthetic */ AvailExtension $extension;
                    final /* synthetic */ Configuration $availLibConfig;
                    final /* synthetic */ AvailPlugin this$0;
                    {
                        this.$extension = $extension;
                        this.$availLibConfig = $availLibConfig;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(Task $this$doLast) {
                        ResolvedArtifact it;
                        Iterable $this$forEach$iv;
                        $this$doLast.getProject().mkdir((Object)this.$extension.getRootsDirectory().getFullPath());
                        $this$doLast.getProject().mkdir((Object)this.$extension.getRepositoryDirectory().getFullPath());
                        Set set = this.$availLibConfig.getResolvedConfiguration().getResolvedArtifacts();
                        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"availLibConfig.resolvedC\u2026uration.resolvedArtifacts");
                        Iterable iterable = set;
                        Object object = this.this$0;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            it = (ResolvedArtifact)element$iv;
                            boolean bl = false;
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            AvailPlugin.access$downloadLib((AvailPlugin)object, it);
                        }
                        $this$forEach$iv = this.$extension.getCreateRoots$avail_plugin().values();
                        object = this.$extension;
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            it = (CreateAvailRoot)element$iv;
                            boolean bl = false;
                            it.create(((AvailExtension)object).getModuleHeaderCommentBody());
                        }
                        $this$forEach$iv = this.$extension.getRoots$avail_plugin().values();
                        boolean $i$f$forEach2 = false;
                        for (T element$iv : $this$forEach$iv) {
                            AvailRoot it2 = (AvailRoot)element$iv;
                            boolean bl = false;
                            it2.getAction().invoke((Object)it2);
                        }
                        AvailProject availProject = this.$extension.createProject();
                        File file = $this$doLast.getProject().getRootDir();
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.rootDir");
                        FilesKt.writeText$default((File)FilesKt.resolve((File)file, (String)(this.$extension.getName() + ".json")), (String)availProject.getFileContent(), null, (int)2, null);
                        File file2 = $this$doLast.getProject().getRootDir();
                        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"project.rootDir");
                        File configDir = FilesKt.resolve((File)file2, (String)".avail");
                        File projectConfigDir = FilesKt.resolve((File)configDir, (String)availProject.getName());
                        projectConfigDir.mkdirs();
                        FilesKt.writeText$default((File)FilesKt.resolve((File)projectConfigDir, (String)".gitignore"), (String)"/**/settings-local.json", null, (int)2, null);
                        AvailArtifactBuildPlan buildPlan = this.$extension.getBuildPlan();
                        FilesKt.writeText$default((File)FilesKt.resolve((File)projectConfigDir, (String)"artifact-plans.json"), (String)AvailArtifactBuildPlan.Companion.fileContent(CollectionsKt.listOf((Object)buildPlan)), null, (int)2, null);
                    }
                }, arg_0));
            }

            private static final void invoke$lambda$1(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }, arg_0));
        target.getTasks().register("anvil", AvailAnvilTask.class, arg_0 -> AvailPlugin.apply$lambda$5(apply.4.INSTANCE, arg_0));
        target.getTasks().register("printAvailConfig", arg_0 -> AvailPlugin.apply$lambda$6((Function1)new Function1<Task, Unit>(extension, target, this){
            final /* synthetic */ AvailExtension $extension;
            final /* synthetic */ Project $target;
            final /* synthetic */ AvailPlugin this$0;
            {
                this.$extension = $extension;
                this.$target = $target;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(Task $this$register) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                $this$register.setGroup("avail");
                $this$register.setDescription("Print the Avail configuration collected from the `avail` extension.");
                Set set = this.$target.getConfigurations().getByName("availLibrary").getResolvedConfiguration().getResolvedArtifacts();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"target.configurations.ge\u2026uration.resolvedArtifacts");
                Iterable iterable = set;
                AvailPlugin availPlugin = this.this$0;
                AvailExtension availExtension = this.$extension;
                boolean $i$f$map = false;
                void var5_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ResolvedArtifact resolvedArtifact = (ResolvedArtifact)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    collection.add(AvailPlugin.access$downloadLib(availPlugin, (ResolvedArtifact)it));
                }
                System.out.println((Object)availExtension.printableConfig(CollectionsKt.toList((Iterable)((List)destination$iv$iv))));
            }
        }, arg_0));
        target.getTasks().register("availArtifactJar", PackageAvailArtifactTask.class, arg_0 -> AvailPlugin.apply$lambda$7(apply.6.INSTANCE, arg_0));
    }

    private final AvailArtifactMetadata downloadLib(ResolvedArtifact artifact) {
        File file;
        String string = artifact.getModuleVersion().getId().getGroup();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"artifact.moduleVersion.id.group");
        String string2 = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"separator");
        String grpPath = StringsKt.replace$default((String)string, (String)".", (String)string2, (boolean)false, (int)4, null);
        String targetDir = AvailEnvironment.INSTANCE.getAvailHomeLibs() + File.separator + grpPath + File.separator;
        new File(targetDir).mkdirs();
        File jarFile = new File(targetDir + artifact.getFile().getName());
        File $this$downloadLib_u24lambda_u248 = file = artifact.getFile();
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$downloadLib_u24lambda_u248, (String)"downloadLib$lambda$8");
        FilesKt.copyTo$default((File)$this$downloadLib_u24lambda_u248, (File)jarFile, (boolean)true, (int)0, (int)4, null);
        URI uRI = jarFile.toURI();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"jarFile.toURI()");
        return AvailArtifactMetadata.Companion.fromJar(uRI, (AvailLocation)new AvailLibraries(grpPath + File.separator + artifact.getFile().getName(), Scheme.JAR, null));
    }

    private static final void apply$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void apply$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void apply$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void apply$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void apply$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ AvailArtifactMetadata access$downloadLib(AvailPlugin $this, ResolvedArtifact artifact) {
        return $this.downloadLib(artifact);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lavail/plugin/AvailPlugin$Companion;", "", "()V", "AVAIL", "", "AVAIL_DEP_GRP", "AVAIL_LIBRARY", "AVAIL_STDLIB_DEP_ARTIFACT_NAME", "avail-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

