/*
 * Decompiled with CFR 0.152.
 */
package avail.plugin;

import avail.plugin.AvailExtension;
import avail.plugin.AvailLibraryDependency;
import avail.plugin.AvailPlugin;
import avail.plugin.AvailStandardLibrary;
import avail.plugin.AvailStdLibVersion;
import avail.plugin.AvailVersion;
import avail.plugin.CreateAvailProjectFileTask;
import avail.plugin.PackageAvailArtifactTask;
import java.io.File;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.availlang.artifact.environment.AvailEnvironment;
import org.availlang.artifact.environment.project.AvailProject;
import org.availlang.artifact.roots.AvailRoot;
import org.availlang.artifact.roots.CreateAvailRoot;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.api.artifacts.UnknownConfigurationException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0018\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lavail/plugin/AvailPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "hasAvailImport", "", "getHasAvailImport$avail_plugin", "()Z", "setHasAvailImport$avail_plugin", "(Z)V", "latestAvail", "", "getLatestAvail$avail_plugin", "()Ljava/lang/String;", "setLatestAvail$avail_plugin", "(Ljava/lang/String;)V", "latestAvailStdLib", "getLatestAvailStdLib$avail_plugin", "setLatestAvailStdLib$avail_plugin", "apply", "", "target", "checkProject", "project", "extension", "Lavail/plugin/AvailExtension;", "Companion", "avail-plugin"})
public final class AvailPlugin
implements Plugin<Project> {
    @NotNull
    private String latestAvailStdLib = "";
    @NotNull
    private String latestAvail = "";
    private boolean hasAvailImport;
    @NotNull
    public static final String AVAIL_DEP_GRP = "org.availlang";
    @NotNull
    public static final String AVAIL_STDLIB_DEP_ARTIFACT_NAME = "avail-stdlib";
    @NotNull
    public static final String AVAIL_STDLIB_DEP = "org.availlang:avail-stdlib";
    @NotNull
    public static final String AVAIL_LIBRARY = "availLibrary";
    @NotNull
    public static final String AVAIL = "avail";
    @NotNull
    public static final String CHECK_CONFIG = "z017f99c2454b49bcbaedc98aa5cbb39b";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getLatestAvailStdLib$avail_plugin() {
        return this.latestAvailStdLib;
    }

    public final void setLatestAvailStdLib$avail_plugin(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.latestAvailStdLib = string;
    }

    @NotNull
    public final String getLatestAvail$avail_plugin() {
        return this.latestAvail;
    }

    public final void setLatestAvail$avail_plugin(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.latestAvail = string;
    }

    public final boolean getHasAvailImport$avail_plugin() {
        return this.hasAvailImport;
    }

    public final void setHasAvailImport$avail_plugin(boolean bl) {
        this.hasAvailImport = bl;
    }

    public void apply(@NotNull Project target) {
        ConfigurationContainer configurationContainer;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        ConfigurationContainer $this$run = configurationContainer = target.getConfigurations();
        boolean bl = false;
        Object object = $this$run.create(AVAIL_LIBRARY);
        Configuration $this$apply = (Configuration)object;
        boolean bl2 = false;
        $this$apply.setTransitive(false);
        $this$apply.setVisible(false);
        $this$apply.setDescription("Config for acquiring published Avail library dependencies");
        object = $this$run.create(CHECK_CONFIG);
        $this$apply = (Configuration)object;
        boolean bl3 = false;
        $this$apply.setTransitive(false);
        $this$apply.setVisible(false);
        $this$apply.setDescription("Config for checking latest versions of Avail published org.availlang libraries.");
        $this$apply.getDependencies().add((Object)new AvailStandardLibrary(null, 1, null).dependency$avail_plugin(target));
        $this$apply.getDependencies().add((Object)target.getDependencies().create((Object)"org.availlang:avail:+"));
        Configuration cfr_ignored_0 = (Configuration)object;
        Object object2 = target.getExtensions().create(AVAIL, AvailExtension.class, new Object[]{target, this});
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"target.extensions.create\u2026va,\n\t\t\t\ttarget,\n\t\t\t\tthis)");
        AvailExtension extension = (AvailExtension)object2;
        target.getTasks().register("checkProject", DefaultTask.class, new Action(this, target, extension){
            final /* synthetic */ AvailPlugin this$0;
            final /* synthetic */ Project $target;
            final /* synthetic */ AvailExtension $extension;

            public final void execute(@NotNull DefaultTask $this$register) {
                Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$receiver");
                $this$register.setGroup("avail");
                $this$register.setDescription("This checks the configured Avail project and displays warnings, errors, or recomendations");
                $this$register.doLast(new Action(this){
                    final /* synthetic */ apply.2 this$0;

                    public final void execute(@NotNull Task $this$doLast) {
                        Intrinsics.checkNotNullParameter((Object)$this$doLast, (String)"$receiver");
                        AvailPlugin.access$checkProject(this.this$0.this$0, this.this$0.$target, this.this$0.$extension);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = availPlugin;
                this.$target = project;
                this.$extension = availExtension;
            }
        });
        target.getTasks().register("initializeAvail", DefaultTask.class, new Action(this, target, extension){
            final /* synthetic */ AvailPlugin this$0;
            final /* synthetic */ Project $target;
            final /* synthetic */ AvailExtension $extension;

            public final void execute(@NotNull DefaultTask $this$register) {
                Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$receiver");
                $this$register.setGroup("avail");
                $this$register.setDescription("Initialize the Avail Project. This sets up the project according to the configuration in the `avail` extension block. At the end of this task, all root initializers (lambdas) that were added will be run.");
                Configuration configuration = this.$target.getConfigurations().getByName("availLibrary");
                Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"target.configurations.getByName(AVAIL_LIBRARY)");
                Configuration availLibConfig = configuration;
                Iterable $this$forEach$iv = this.$extension.getRootDependencies$avail_plugin();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    AvailLibraryDependency it = (AvailLibraryDependency)element$iv;
                    boolean bl = false;
                    Dependency dependency = it.dependency$avail_plugin(this.$target);
                    availLibConfig.getDependencies().add((Object)dependency);
                }
                $this$register.doLast(new Action(this, availLibConfig){
                    final /* synthetic */ apply.3 this$0;
                    final /* synthetic */ Configuration $availLibConfig;

                    public final void execute(@NotNull Task $this$doLast) {
                        ResolvedArtifact it;
                        Intrinsics.checkNotNullParameter((Object)$this$doLast, (String)"$receiver");
                        $this$doLast.getProject().mkdir((Object)this.this$0.$extension.getRootsDirectory().getFullPath());
                        $this$doLast.getProject().mkdir((Object)this.this$0.$extension.getRepositoryDirectory().getFullPath());
                        ResolvedConfiguration resolvedConfiguration = this.$availLibConfig.getResolvedConfiguration();
                        Intrinsics.checkNotNullExpressionValue((Object)resolvedConfiguration, (String)"availLibConfig.resolvedConfiguration");
                        Set set = resolvedConfiguration.getResolvedArtifacts();
                        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"availLibConfig.resolvedC\u2026uration.resolvedArtifacts");
                        Iterable $this$forEach$iv = set;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            File file;
                            it = (ResolvedArtifact)element$iv;
                            boolean bl = false;
                            ResolvedArtifact resolvedArtifact = it;
                            Intrinsics.checkNotNullExpressionValue((Object)resolvedArtifact, (String)"it");
                            ResolvedModuleVersion resolvedModuleVersion = resolvedArtifact.getModuleVersion();
                            Intrinsics.checkNotNullExpressionValue((Object)resolvedModuleVersion, (String)"it.moduleVersion");
                            ModuleVersionIdentifier moduleVersionIdentifier = resolvedModuleVersion.getId();
                            Intrinsics.checkNotNullExpressionValue((Object)moduleVersionIdentifier, (String)"it.moduleVersion.id");
                            String string = moduleVersionIdentifier.getGroup();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.moduleVersion.id.group");
                            String string2 = File.separator;
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"File.separator");
                            String grpPath = StringsKt.replace$default((String)string, (String)".", (String)string2, (boolean)false, (int)4, null);
                            String targetDir = AvailEnvironment.INSTANCE.getAvailHomeLibs() + File.separator + grpPath + File.separator;
                            new File(targetDir).mkdirs();
                            File $this$apply = file = it.getFile();
                            boolean bl2 = false;
                            FilesKt.copyTo$default((File)$this$apply, (File)new File(targetDir + $this$apply.getName()), (boolean)true, (int)0, (int)4, null);
                        }
                        $this$forEach$iv = this.this$0.$extension.getCreateRoots$avail_plugin().values();
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            it = (CreateAvailRoot)element$iv;
                            boolean bl = false;
                            it.create(this.this$0.$extension.getModuleHeaderCommentBody());
                        }
                        $this$forEach$iv = this.this$0.$extension.getRoots$avail_plugin().values();
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            it = (AvailRoot)element$iv;
                            boolean bl = false;
                            it.getAction().invoke((Object)it);
                        }
                        AvailPlugin.access$checkProject(this.this$0.this$0, this.this$0.$target, this.this$0.$extension);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$availLibConfig = configuration;
                    }
                });
            }
            {
                this.this$0 = availPlugin;
                this.$target = project;
                this.$extension = availExtension;
            }
        });
        target.getTasks().register("printAvailConfig", new Action(extension){
            final /* synthetic */ AvailExtension $extension;

            public final void execute(@NotNull Task $this$register) {
                Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$receiver");
                $this$register.setGroup("avail");
                $this$register.setDescription("Print the Avail configuration collected from the `avail` extension.");
                $this$register.dependsOn(new Object[]{"initializeAvail"});
                String string = this.$extension.getPrintableConfig();
                System.out.println((Object)string);
            }
            {
                this.$extension = availExtension;
            }
        });
        target.getTasks().register("availArtifactJar", PackageAvailArtifactTask.class, (Action)apply.5.INSTANCE);
        target.getTasks().register("createProjectFile", CreateAvailProjectFileTask.class, new Action(extension){
            final /* synthetic */ AvailExtension $extension;

            public final void execute(@NotNull CreateAvailProjectFileTask $this$register) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$receiver");
                $this$register.setGroup("avail");
                $this$register.setDescription("Creates a new AvailProject file based on the configuration of the AvailExtension.");
                $this$register.dependsOn(new Object[]{"initializeAvail"});
                $this$register.doLast(new Action(this){
                    final /* synthetic */ apply.6 this$0;

                    public final void execute(@NotNull Task $this$doLast) {
                        Intrinsics.checkNotNullParameter((Object)$this$doLast, (String)"$receiver");
                        AvailProject availProject = this.this$0.$extension.createProject();
                        Project project = $this$doLast.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                        File file = project.getRootDir();
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.rootDir");
                        FilesKt.writeText$default((File)FilesKt.resolve((File)file, (String)"avail-config.json"), (String)availProject.getFileContent(), null, (int)2, null);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$extension = availExtension;
            }
        });
    }

    private final void checkProject(Project project, AvailExtension extension) {
        String string;
        Object setV;
        AvailVersion latestV;
        String it;
        String string2;
        Dependency d;
        Object element$iv;
        Configuration configuration = project.getConfigurations().getByName(CHECK_CONFIG);
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"project.configurations.getByName(CHECK_CONFIG)");
        Configuration checkConfig = configuration;
        ResolvedConfiguration resolvedConfiguration = checkConfig.getResolvedConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)resolvedConfiguration, (String)"checkConfig.resolvedConfiguration");
        ResolvedConfiguration resolvedConfig = resolvedConfiguration;
        Set set = resolvedConfig.getFirstLevelModuleDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"resolvedConfig.firstLevelModuleDependencies");
        Set resolvedDependencies = set;
        Object $this$forEach$iv = resolvedDependencies;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            ResolvedDependency it2 = (ResolvedDependency)element$iv;
            boolean bl = false;
            ResolvedDependency resolvedDependency = it2;
            Intrinsics.checkNotNullExpressionValue((Object)resolvedDependency, (String)"it");
            if (Intrinsics.areEqual((Object)resolvedDependency.getModuleName(), (Object)AVAIL)) {
                Intrinsics.checkNotNullExpressionValue((Object)it2.getModuleVersion(), (String)"it.moduleVersion");
                this.latestAvail = this.latestAvail;
            }
            if (!Intrinsics.areEqual((Object)it2.getModuleName(), (Object)AVAIL_STDLIB_DEP_ARTIFACT_NAME)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)it2.getModuleVersion(), (String)"it.moduleVersion");
            this.latestAvailStdLib = this.latestAvailStdLib;
        }
        try {
            Configuration configuration2 = project.getConfigurations().getByName("implementation");
            Intrinsics.checkNotNullExpressionValue((Object)configuration2, (String)"project.configurations.getByName(\"implementation\")");
            DependencySet dependencySet = configuration2.getDependencies();
            Intrinsics.checkNotNullExpressionValue((Object)dependencySet, (String)"project.configurations.g\u2026ation\")\n\t\t\t\t.dependencies");
            $this$forEach$iv = (Iterable)dependencySet;
            $i$f$forEach = false;
            iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                d = (Dependency)element$iv;
                boolean bl = false;
                Dependency dependency = d;
                Intrinsics.checkNotNullExpressionValue((Object)dependency, (String)"d");
                if (!Intrinsics.areEqual((Object)dependency.getGroup(), (Object)AVAIL_DEP_GRP) || !Intrinsics.areEqual((Object)d.getName(), (Object)AVAIL)) continue;
                this.hasAvailImport = true;
                if (d.getVersion() == null) continue;
                it = string2;
                boolean bl2 = false;
                CharSequence charSequence = this.latestAvail;
                if (!(charSequence.length() > 0)) continue;
                String string3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it");
                latestV = new AvailVersion(this.latestAvail);
                setV = new AvailVersion(string3);
                if (latestV.compareTo((AvailVersion)setV) <= 0) continue;
                string = "A newer version of Avail is available: " + "org.availlang:avail:" + this.latestAvail;
                System.out.println((Object)string);
            }
        }
        catch (UnknownConfigurationException $this$forEach$iv2) {
            // empty catch block
        }
        try {
            Configuration configuration3 = project.getConfigurations().getByName("api");
            Intrinsics.checkNotNullExpressionValue((Object)configuration3, (String)"project.configurations.getByName(\"api\")");
            DependencySet dependencySet = configuration3.getDependencies();
            Intrinsics.checkNotNullExpressionValue((Object)dependencySet, (String)"project.configurations.g\u2026(\"api\")\n\t\t\t\t.dependencies");
            $this$forEach$iv = (Iterable)dependencySet;
            $i$f$forEach = false;
            iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                d = (Dependency)element$iv;
                boolean bl = false;
                Dependency dependency = d;
                Intrinsics.checkNotNullExpressionValue((Object)dependency, (String)"d");
                if (!Intrinsics.areEqual((Object)dependency.getGroup(), (Object)AVAIL_DEP_GRP) || !Intrinsics.areEqual((Object)d.getName(), (Object)AVAIL)) continue;
                this.hasAvailImport = true;
                if (d.getVersion() == null) continue;
                it = string2;
                boolean bl3 = false;
                setV = this.latestAvail;
                if (!(setV.length() > 0)) continue;
                String string4 = it;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"it");
                latestV = new AvailVersion(this.latestAvail);
                setV = new AvailVersion(string4);
                if (latestV.compareTo((AvailVersion)setV) <= 0) continue;
                string = "A newer version of Avail is available: " + "org.availlang:avail:" + this.latestAvail;
                System.out.println((Object)string);
            }
        }
        catch (UnknownConfigurationException $this$forEach$iv3) {
            // empty catch block
        }
        if (!this.hasAvailImport) {
            System.err.println();
            $this$forEach$iv = "WARNING: No Avail dependency. Consider adding `implementation(" + "\"org.availlang:avail:" + this.latestAvail + "\")` to the " + "`dependencies` section of the build script.";
            System.out.println($this$forEach$iv);
        }
        if (extension.getUsesStdLib$avail_plugin()) {
            AvailStdLibVersion setV2;
            AvailStdLibVersion latestV2;
            String currentV = extension.getAvailStandardLibrary$avail_plugin().getVersion();
            CharSequence $i$f$forEach2 = this.latestAvailStdLib;
            if ($i$f$forEach2.length() > 0 && (latestV2 = new AvailStdLibVersion(this.latestAvailStdLib)).compareTo(setV2 = new AvailStdLibVersion(currentV)) > 0) {
                String string5 = "RECOMMENDATION: A newer version of the Avail Standard Library is available: " + "org.availlang:avail-stdlib:" + this.latestAvailStdLib;
                System.out.println((Object)string5);
            }
        }
    }

    public AvailPlugin() {
        AvailEnvironment.INSTANCE.optionallyCreateAvailUserHome();
    }

    public static final /* synthetic */ void access$checkProject(AvailPlugin $this, Project project, AvailExtension extension) {
        $this.checkProject(project, extension);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lavail/plugin/AvailPlugin$Companion;", "", "()V", "AVAIL", "", "AVAIL_DEP_GRP", "AVAIL_LIBRARY", "AVAIL_STDLIB_DEP", "AVAIL_STDLIB_DEP_ARTIFACT_NAME", "CHECK_CONFIG", "avail-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

