/*
 * Decompiled with CFR 0.152.
 */
package avail.plugin;

import avail.plugin.AvailExtension;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.availlang.artifact.AvailArtifactType;
import org.availlang.artifact.jar.AvailArtifactJarBuilder;
import org.availlang.artifact.jar.JvmComponent;
import org.availlang.artifact.manifest.AvailArtifactManifest;
import org.availlang.artifact.roots.AvailRoot;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 J2\u00020\u0001:\u0001JB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u001dJ\u0016\u0010?\u001a\u00020=2\u0006\u0010>\u001a\u00020\u001d2\u0006\u0010@\u001a\u00020\u0004J\u000e\u0010A\u001a\u00020=2\u0006\u0010B\u001a\u00020$J\u000e\u0010C\u001a\u00020=2\u0006\u0010D\u001a\u00020\u0004J\u000e\u0010E\u001a\u00020=2\u0006\u0010F\u001a\u00020;J\b\u0010G\u001a\u00020=H\u0007J\u000e\u0010H\u001a\u00020=2\u0006\u0010H\u001a\u00020\u0004J\u000e\u0010H\u001a\u00020=2\u0006\u0010H\u001a\u00020IR\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001e\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0006\"\u0004\b \u0010\bR \u0010!\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00040\"0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010%\u001a\u00020&8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001b\u0010+\u001a\u00020,8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b-\u0010.R\u001e\u00101\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u0006\"\u0004\b3\u0010\bR\u0014\u00104\u001a\b\u0012\u0004\u0012\u0002050\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00106\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u0006R\u001a\u00108\u001a\b\u0012\u0004\u0012\u00020\u00040\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u000fR\u0014\u0010:\u001a\b\u0012\u0004\u0012\u00020;0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lavail/plugin/CreateAvailArtifactJar;", "Lorg/gradle/api/DefaultTask;", "()V", "artifactDescription", "", "getArtifactDescription", "()Ljava/lang/String;", "setArtifactDescription", "(Ljava/lang/String;)V", "artifactDigestAlgorithm", "getArtifactDigestAlgorithm", "setArtifactDigestAlgorithm", "artifactName", "Lorg/gradle/api/provider/Property;", "getArtifactName", "()Lorg/gradle/api/provider/Property;", "artifactType", "Lorg/availlang/artifact/AvailArtifactType;", "getArtifactType", "()Lorg/availlang/artifact/AvailArtifactType;", "setArtifactType", "(Lorg/availlang/artifact/AvailArtifactType;)V", "availExtension", "Lavail/plugin/AvailExtension;", "getAvailExtension", "()Lavail/plugin/AvailExtension;", "configName", "directories", "", "Ljava/io/File;", "implementationTitle", "getImplementationTitle", "setImplementationTitle", "includedFiles", "Lkotlin/Pair;", "jars", "Ljava/util/jar/JarFile;", "jvmComponent", "Lorg/availlang/artifact/jar/JvmComponent;", "getJvmComponent", "()Lorg/availlang/artifact/jar/JvmComponent;", "setJvmComponent", "(Lorg/availlang/artifact/jar/JvmComponent;)V", "localConfig", "Lorg/gradle/api/artifacts/Configuration;", "getLocalConfig", "()Lorg/gradle/api/artifacts/Configuration;", "localConfig$delegate", "Lkotlin/Lazy;", "outputDirectory", "getOutputDirectory", "setOutputDirectory", "roots", "Lorg/availlang/artifact/roots/AvailRoot;", "targetOutputJar", "getTargetOutputJar", "version", "getVersion", "zipFiles", "Ljava/util/zip/ZipFile;", "addDirectory", "", "file", "addFile", "targetDirectory", "addJar", "jar", "addRoot", "root", "addZipFile", "zipFile", "createAvailArtifactJar", "dependency", "Lorg/gradle/api/artifacts/Dependency;", "Companion", "avail-plugin"})
public abstract class CreateAvailArtifactJar
extends DefaultTask {
    private final String configName = "_createAvailArtifact" + this.getName();
    private final Lazy localConfig$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Configuration>(this){
        final /* synthetic */ CreateAvailArtifactJar this$0;

        @NotNull
        public final Configuration invoke() {
            Project project = this.this$0.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            Object object = project.getConfigurations().create(CreateAvailArtifactJar.access$getConfigName$p(this.this$0));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.configurations.create(configName)");
            return (Configuration)object;
        }
        {
            this.this$0 = createAvailArtifactJar;
            super(0);
        }
    }));
    @Input
    @NotNull
    private AvailArtifactType artifactType = AvailArtifactType.APPLICATION;
    @Input
    @NotNull
    private JvmComponent jvmComponent = JvmComponent.Companion.getNONE();
    @Input
    @NotNull
    private String artifactDescription = "";
    @Input
    @NotNull
    private String implementationTitle;
    @Input
    @NotNull
    private String artifactDigestAlgorithm;
    @Input
    @NotNull
    private String outputDirectory;
    private final List<AvailRoot> roots;
    private final List<Pair<File, String>> includedFiles;
    private final List<JarFile> jars;
    private final List<ZipFile> zipFiles;
    private final List<File> directories;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final AvailExtension getAvailExtension() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Object object = project.getExtensions().findByType(AvailExtension.class);
        Intrinsics.checkNotNull((Object)object);
        return (AvailExtension)object;
    }

    private final Configuration getLocalConfig() {
        Lazy lazy = this.localConfig$delegate;
        CreateAvailArtifactJar createAvailArtifactJar = this;
        Object var3_3 = null;
        return (Configuration)lazy.getValue();
    }

    @Input
    @NotNull
    public abstract Property<String> getArtifactName();

    @Input
    @NotNull
    public abstract Property<String> getVersion();

    @NotNull
    public final AvailArtifactType getArtifactType() {
        return this.artifactType;
    }

    public final void setArtifactType(@NotNull AvailArtifactType availArtifactType) {
        Intrinsics.checkNotNullParameter((Object)availArtifactType, (String)"<set-?>");
        this.artifactType = availArtifactType;
    }

    @NotNull
    public final JvmComponent getJvmComponent() {
        return this.jvmComponent;
    }

    public final void setJvmComponent(@NotNull JvmComponent jvmComponent) {
        Intrinsics.checkNotNullParameter((Object)jvmComponent, (String)"<set-?>");
        this.jvmComponent = jvmComponent;
    }

    @NotNull
    public final String getArtifactDescription() {
        return this.artifactDescription;
    }

    public final void setArtifactDescription(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.artifactDescription = string;
    }

    @NotNull
    public final String getImplementationTitle() {
        return this.implementationTitle;
    }

    public final void setImplementationTitle(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.implementationTitle = string;
    }

    @NotNull
    public final String getArtifactDigestAlgorithm() {
        return this.artifactDigestAlgorithm;
    }

    public final void setArtifactDigestAlgorithm(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.artifactDigestAlgorithm = string;
    }

    @NotNull
    public final String getOutputDirectory() {
        return this.outputDirectory;
    }

    public final void setOutputDirectory(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.outputDirectory = string;
    }

    private final String getTargetOutputJar() {
        Object object = this.getVersion().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"version.get()");
        CharSequence charSequence = (CharSequence)object;
        String suffix = !StringsKt.isBlank((CharSequence)charSequence) ? "" + '-' + this.getVersion() + ".jar" : ".jar";
        return this.outputDirectory + (String)this.getArtifactName().get() + suffix;
    }

    public final void addRoot(@NotNull String root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        AvailRoot targetRoot = this.getAvailExtension().getRoots$avail_plugin().get(root);
        if (targetRoot == null) {
            System.err.println("Added AvailRoot, " + root + ", to CreateAvailArtifactJar task, " + this.getName() + " in " + this.getGroup() + " group, but this root has not been " + "configured for use in the AvailExtension section, " + "avail {}, of the build script. To add this root to " + "the AvailExtension configuration block use " + "`includeAvailLibDependency()`.");
            return;
        }
        this.roots.add(targetRoot);
    }

    public final void addFile(@NotNull File file, @NotNull String targetDirectory) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        boolean bl2 = bl = !file.isDirectory();
        if (!bl) {
            boolean bl3 = false;
            String string = "Expected " + file + " to be a file not a directory!";
            throw new IllegalArgumentException(string.toString());
        }
        this.includedFiles.add((Pair<File, String>)TuplesKt.to((Object)file, (Object)targetDirectory));
    }

    public final void addJar(@NotNull JarFile jar) {
        Intrinsics.checkNotNullParameter((Object)jar, (String)"jar");
        this.jars.add(jar);
    }

    public final void addZipFile(@NotNull ZipFile zipFile) {
        Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
        this.zipFiles.add(zipFile);
    }

    public final void addDirectory(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.directories.add(file);
    }

    public final void dependency(@NotNull String dependency) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        DependencySet dependencySet = this.getLocalConfig().getDependencies();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        dependencySet.add((Object)project.getDependencies().create((Object)dependency));
    }

    public final void dependency(@NotNull Dependency dependency) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        this.getLocalConfig().getDependencies().add((Object)dependency);
    }

    @TaskAction
    public final void createAvailArtifactJar() {
        Object object = this.getVersion().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"version.get()");
        Companion.createAvailArtifactJar((String)object, this.getTargetOutputJar(), this.artifactType, this.jvmComponent, this.implementationTitle, this.artifactDescription, this.roots, this.includedFiles, this.jars, this.zipFiles, this.directories, this.getLocalConfig());
    }

    public CreateAvailArtifactJar() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        String string = project.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.name");
        this.implementationTitle = string;
        this.artifactDigestAlgorithm = "SHA-256";
        StringBuilder stringBuilder = new StringBuilder();
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        this.outputDirectory = stringBuilder.append(project2.getBuildDir()).append("/libs/").toString();
        this.roots = new ArrayList();
        this.includedFiles = new ArrayList();
        this.jars = new ArrayList();
        this.zipFiles = new ArrayList();
        this.directories = new ArrayList();
        this.setGroup("build");
        this.setDescription("Create an Avail artifact jar.");
    }

    public static final /* synthetic */ String access$getConfigName$p(CreateAvailArtifactJar $this) {
        return $this.configName;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0090\u0001\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0018\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00060\u00120\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u000f2\u0006\u0010\u0019\u001a\u00020\u001a\u00a8\u0006\u001b"}, d2={"Lavail/plugin/CreateAvailArtifactJar$Companion;", "", "()V", "createAvailArtifactJar", "", "version", "", "outputLocation", "artifactType", "Lorg/availlang/artifact/AvailArtifactType;", "jvmComponent", "Lorg/availlang/artifact/jar/JvmComponent;", "implementationTitle", "artifactDescription", "roots", "", "Lorg/availlang/artifact/roots/AvailRoot;", "includedFiles", "Lkotlin/Pair;", "Ljava/io/File;", "jars", "Ljava/util/jar/JarFile;", "zipFiles", "Ljava/util/zip/ZipFile;", "directories", "dependencyConfiguration", "Lorg/gradle/api/artifacts/Configuration;", "avail-plugin"})
    public static final class Companion {
        public final void createAvailArtifactJar(@NotNull String version, @NotNull String outputLocation, @NotNull AvailArtifactType artifactType, @NotNull JvmComponent jvmComponent, @NotNull String implementationTitle, @NotNull String artifactDescription, @NotNull List<? extends AvailRoot> roots, @NotNull List<? extends Pair<? extends File, String>> includedFiles, @NotNull List<? extends JarFile> jars, @NotNull List<? extends ZipFile> zipFiles, @NotNull List<? extends File> directories, @NotNull Configuration dependencyConfiguration) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)outputLocation, (String)"outputLocation");
            Intrinsics.checkNotNullParameter((Object)artifactType, (String)"artifactType");
            Intrinsics.checkNotNullParameter((Object)jvmComponent, (String)"jvmComponent");
            Intrinsics.checkNotNullParameter((Object)implementationTitle, (String)"implementationTitle");
            Intrinsics.checkNotNullParameter((Object)artifactDescription, (String)"artifactDescription");
            Intrinsics.checkNotNullParameter(roots, (String)"roots");
            Intrinsics.checkNotNullParameter(includedFiles, (String)"includedFiles");
            Intrinsics.checkNotNullParameter(jars, (String)"jars");
            Intrinsics.checkNotNullParameter(zipFiles, (String)"zipFiles");
            Intrinsics.checkNotNullParameter(directories, (String)"directories");
            Intrinsics.checkNotNullParameter((Object)dependencyConfiguration, (String)"dependencyConfiguration");
            Object object = "Creating " + outputLocation + '\u2026';
            System.out.println(object);
            Object $this$apply = object = new File(outputLocation);
            boolean bl = false;
            new File(((File)$this$apply).getParent()).mkdirs();
            ((File)$this$apply).delete();
            Map manifestMap = new LinkedHashMap();
            Iterable $this$forEach$iv = roots;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AvailRoot it = (AvailRoot)element$iv;
                boolean bl2 = false;
                manifestMap.put(it.getName(), it.getManifest());
            }
            AvailArtifactJarBuilder jarBuilder = new AvailArtifactJarBuilder(outputLocation, version, implementationTitle, AvailArtifactManifest.Companion.manifestFile(artifactType, manifestMap, artifactDescription, jvmComponent), null, 16, null);
            Iterable $this$forEach$iv2 = roots;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                AvailRoot it = (AvailRoot)element$iv;
                boolean bl3 = false;
                String string = "Adding Root\n\t" + it;
                System.out.println((Object)string);
                jarBuilder.addRoot(it);
            }
            $this$forEach$iv2 = includedFiles;
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                Pair it = (Pair)element$iv;
                boolean bl4 = false;
                jarBuilder.addFile((File)it.getFirst(), (String)it.getSecond());
            }
            $this$forEach$iv2 = jars;
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                JarFile it = (JarFile)element$iv;
                boolean bl5 = false;
                jarBuilder.addJar(it);
            }
            $this$forEach$iv2 = zipFiles;
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                ZipFile it = (ZipFile)element$iv;
                boolean bl6 = false;
                jarBuilder.addZip(it);
            }
            $this$forEach$iv2 = directories;
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                File it = (File)element$iv;
                boolean bl7 = false;
                jarBuilder.addDir(it);
            }
            Set set = dependencyConfiguration.resolve();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"dependencyConfiguration.resolve()");
            $this$forEach$iv2 = set;
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                File it = (File)element$iv;
                boolean bl8 = false;
                File file = it;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it");
                String string = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                if (StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) {
                    jarBuilder.addJar(new JarFile(it));
                    continue;
                }
                String string2 = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
                if (StringsKt.endsWith$default((String)string2, (String)".zip", (boolean)false, (int)2, null)) {
                    jarBuilder.addZip(new ZipFile(it));
                    continue;
                }
                if (it.isDirectory()) {
                    jarBuilder.addDir(it);
                    continue;
                }
                throw (Throwable)new RuntimeException("Failed to build " + outputLocation + ": received dependency " + it.getAbsolutePath() + " which did not resolved to a" + " jar, zip, or directory");
            }
            jarBuilder.finish();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

