/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine.webjars;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebJarsServlet
extends HttpServlet {
    private static final int BUFSIZE = 4096;
    private final String destination;

    public WebJarsServlet(String destination) {
        this.destination = destination;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path = request.getPathInfo();
        if (path == null) {
            response.sendError(404);
            return;
        }
        String mimetype = request.getServletContext().getMimeType(path);
        if (mimetype == null) {
            mimetype = "application/octet-stream";
        }
        response.setContentType(mimetype);
        try (InputStream stream = WebJarsServlet.class.getResourceAsStream(this.destination + path);
             DataInputStream dataStream = new DataInputStream(stream);
             ServletOutputStream out = response.getOutputStream();){
            int length;
            if (stream == null) {
                response.sendError(404);
                return;
            }
            byte[] byteBuffer = new byte[4096];
            while ((length = dataStream.read(byteBuffer)) != -1) {
                out.write(byteBuffer, 0, length);
            }
        }
    }
}

