/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine.shiro.simple;

import com.google.inject.Module;
import com.google.inject.PrivateModule;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.shiro.realm.Realm;
import org.atteo.moonshine.shiro.RealmService;
import org.atteo.moonshine.shiro.simple.Account;
import org.atteo.moonshine.shiro.simple.InPlaceRealm;

@XmlRootElement(name="in-place")
public class InPlaceRealmService
extends RealmService {
    @XmlElementWrapper(name="accounts")
    @XmlElement(name="account")
    private List<Account> accounts;

    public Module configure() {
        return new PrivateModule(){

            protected void configure() {
                InPlaceRealm realm = new InPlaceRealm();
                if (InPlaceRealmService.this.accounts != null) {
                    for (Account account : InPlaceRealmService.this.accounts) {
                        String[] roles = new String[]{};
                        if (account.getRoles() != null) {
                            roles = account.getRoles().toArray(new String[account.getRoles().size()]);
                        }
                        realm.addAccount(account.getUsername(), account.getPassword(), account.isAdministrator(), roles);
                    }
                }
                this.bind(Realm.class).toInstance((Object)realm);
                this.expose(Realm.class);
            }
        };
    }
}

