/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine.shiro;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.PrivateModule;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.guice.ShiroModule;
import org.apache.shiro.guice.aop.ShiroAopModule;
import org.apache.shiro.guice.web.GuiceShiroFilter;
import org.apache.shiro.guice.web.ShiroWebModule;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.util.ThreadContext;
import org.apache.shiro.web.filter.mgt.FilterChainResolver;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.atteo.config.XmlDefaultValue;
import org.atteo.moonshine.TopLevelService;
import org.atteo.moonshine.services.Service;
import org.atteo.moonshine.shiro.RealmService;

@XmlRootElement(name="shiro")
public class ShiroService
extends TopLevelService {
    @XmlElement
    @XmlDefaultValue(value="true")
    private Boolean aop;
    @XmlElementWrapper(name="realms")
    @XmlElementRef
    private List<RealmService> realms = new ArrayList<RealmService>();
    @XmlElement
    private String prefix = "/*";
    @Inject
    private SecurityManager securityManager;

    public Iterable<? extends Service> getSubServices() {
        return this.realms;
    }

    public Module configure() {
        return new PrivateModule(){

            protected void configure() {
                this.install((Module)new ShiroModule(){

                    protected void configureShiro() {
                        Multibinder setBinder = Multibinder.newSetBinder((Binder)this.binder(), Realm.class);
                        for (RealmService realm : ShiroService.this.realms) {
                            if (realm.getId() == null) {
                                setBinder.addBinding().to(Realm.class);
                                continue;
                            }
                            setBinder.addBinding().to(Key.get(Realm.class, (Annotation)Names.named((String)realm.getId())));
                        }
                        try {
                            this.bind(WebSecurityManager.class).toConstructor(DefaultWebSecurityManager.class.getConstructor(Collection.class)).asEagerSingleton();
                        }
                        catch (NoSuchMethodException e) {
                            this.addError(e);
                        }
                        this.expose(WebSecurityManager.class);
                    }

                    protected void bindSessionManager(AnnotatedBindingBuilder<SessionManager> bind) {
                        bind.to(DefaultWebSessionManager.class).asEagerSingleton();
                    }
                });
                FilterChainResolver filterChainResolver = new FilterChainResolver(){

                    public FilterChain getChain(ServletRequest request, ServletResponse response, FilterChain chain) {
                        return null;
                    }
                };
                this.bind(FilterChainResolver.class).toInstance((Object)filterChainResolver);
                this.bind(GuiceShiroFilter.class).asEagerSingleton();
                this.install((Module)ShiroWebModule.guiceFilterModule((String)ShiroService.this.prefix));
                if (ShiroService.this.aop.booleanValue()) {
                    this.install((Module)new ShiroAopModule());
                }
                this.expose(SecurityManager.class);
                this.expose(WebSecurityManager.class);
            }
        };
    }

    public void start() {
        SecurityUtils.setSecurityManager((SecurityManager)this.securityManager);
    }

    public void close() {
        SecurityUtils.setSecurityManager(null);
        ThreadContext.unbindSecurityManager();
        ThreadContext.unbindSubject();
    }
}

