/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine.shiro.database;

import com.google.inject.Module;
import com.google.inject.PrivateModule;
import com.google.inject.Provider;
import javax.inject.Singleton;
import javax.sql.DataSource;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.shiro.realm.Realm;
import org.atteo.moonshine.database.DatabaseMigration;
import org.atteo.moonshine.database.DatabaseService;
import org.atteo.moonshine.jpa.JpaService;
import org.atteo.moonshine.liquibase.LiquibaseFacade;
import org.atteo.moonshine.services.ImportService;
import org.atteo.moonshine.shiro.RealmService;
import org.atteo.moonshine.shiro.database.AccountRepository;
import org.atteo.moonshine.shiro.database.DatabaseRealm;
import org.atteo.moonshine.springdata.RepositoryFactoryProvider;
import org.atteo.moonshine.springdata.RepositoryProvider;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;

@XmlRootElement(name="database")
public class DatabaseRealmService
extends RealmService {
    @ImportService
    @XmlIDREF
    private JpaService jpa;
    @ImportService
    private DatabaseService database;

    public Module configure() {
        this.database = this.jpa.getDatabaseService();
        this.database.registerMigration(new DatabaseMigration(){

            public void execute(DataSource dataSource) {
                new LiquibaseFacade(dataSource).migrate("liquibase/database-realm.xml");
            }
        });
        return new PrivateModule(){

            protected void configure() {
                this.bind(RepositoryFactorySupport.class).toProvider(RepositoryFactoryProvider.class).in(Singleton.class);
                this.bind(AccountRepository.class).toProvider((Provider)new RepositoryProvider(AccountRepository.class)).in(Singleton.class);
                this.bind(Realm.class).to(DatabaseRealm.class);
                this.expose(AccountRepository.class);
                this.expose(Realm.class);
            }
        };
    }
}

