/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine.shiro.database;

import com.google.inject.Inject;
import java.io.Serializable;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.apache.shiro.codec.Hex;
import org.apache.shiro.crypto.RandomNumberGenerator;
import org.apache.shiro.crypto.SecureRandomNumberGenerator;
import org.apache.shiro.crypto.hash.SimpleHash;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.util.ByteSource;
import org.apache.shiro.util.SimpleByteSource;
import org.atteo.moonshine.shiro.database.Account;
import org.atteo.moonshine.shiro.database.AccountRepository;

public class DatabaseRealm
extends AuthenticatingRealm {
    private final int hashIterations = 1536;
    private final String hashAlgorithm = "SHA-256";
    private final RandomNumberGenerator randomNumberGenerator = new SecureRandomNumberGenerator();
    @Inject
    private AccountRepository accountRepository;

    public DatabaseRealm() {
        HashedCredentialsMatcher credentialsMatcher = new HashedCredentialsMatcher("SHA-256");
        credentialsMatcher.setHashIterations(1536);
        this.setCredentialsMatcher((CredentialsMatcher)credentialsMatcher);
        this.setName("LoginRealm");
    }

    public int getHashIterations() {
        return 1536;
    }

    public String getHashAlgorithm() {
        return "SHA-256";
    }

    public ByteSource generateSalt() {
        return this.randomNumberGenerator.nextBytes();
    }

    public String hashPassword(String password, ByteSource salt) {
        return new SimpleHash("SHA-256", (Object)password, (Object)salt, 1536).toHex();
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        String principal = (String)token.getPrincipal();
        Account loginAccount = (Account)this.accountRepository.findOne((Serializable)((Object)principal));
        if (loginAccount == null) {
            return null;
        }
        SimplePrincipalCollection principalCollection = new SimplePrincipalCollection((Object)loginAccount.getLogin(), this.getName());
        SimpleAuthenticationInfo info = new SimpleAuthenticationInfo((PrincipalCollection)principalCollection, (Object)loginAccount.getHashedPassword(), (ByteSource)new SimpleByteSource(Hex.decode((String)loginAccount.getSalt())));
        return info;
    }
}

