/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine.orientdb;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.persist.PersistService;
import com.google.inject.servlet.RequestScoped;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentPool;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.atteo.config.XmlDefaultValue;
import org.atteo.moonshine.TopLevelService;

@XmlRootElement(name="orientdb")
public class OrientDb
extends TopLevelService {
    @XmlElement(name="url")
    @XmlDefaultValue(value="local:${dataHome}/orientdb")
    private String url;
    @XmlElement(name="autocreate")
    @XmlDefaultValue(value="true")
    private Boolean autocreate;
    @XmlDefaultValue(value="admin")
    private String username;
    @XmlDefaultValue(value="admin")
    private String password;
    @XmlElement(name="pool-timeout")
    @XmlDefaultValue(value="600000")
    private Integer poolTimeout;
    private PersistService persistService;
    private Provider<ODatabaseDocumentTx> provider = new Provider<ODatabaseDocumentTx>(){

        public ODatabaseDocumentTx get() {
            return (ODatabaseDocumentTx)ODatabaseDocumentPool.global().acquire(OrientDb.this.url, OrientDb.this.username, OrientDb.this.password);
        }
    };

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Boolean getAutocreate() {
        return this.autocreate;
    }

    public Module configure() {
        return new AbstractModule(){

            protected void configure() {
                OGlobalConfiguration.CLIENT_CONNECT_POOL_WAIT_TIMEOUT.setValue((Object)OrientDb.this.poolTimeout);
                this.bind(ODatabaseDocumentTx.class).toProvider(OrientDb.this.provider).in(RequestScoped.class);
            }
        };
    }

    public void start() {
        if (this.getAutocreate().booleanValue()) {
            ODatabaseDocumentTx db = new ODatabaseDocumentTx(this.url);
            if (!db.exists()) {
                db.create();
            }
            db.close();
        }
    }

    public void stop() {
    }
}

