/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine.logback;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.jmx.JMXConfigurator;
import com.google.inject.Inject;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.xml.bind.annotation.XmlRootElement;
import org.atteo.moonshine.TopLevelService;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="logback")
public class LogBack
extends TopLevelService {
    @Inject
    private MBeanServer mbeanServer;
    private JMXConfigurator jmxConfigurator;

    public void start() {
        this.configureJMX();
    }

    public void close() {
        this.deconfigureJMX();
    }

    private void configureJMX() throws RuntimeException {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        try {
            ObjectName name = ObjectName.getInstance(JMXConfigurator.class.getPackage().getName() + ":type=" + JMXConfigurator.class.getSimpleName());
            this.jmxConfigurator = new JMXConfigurator(context, this.mbeanServer, name);
            if (!this.mbeanServer.isRegistered(name)) {
                this.mbeanServer.registerMBean(this.jmxConfigurator, name);
            }
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            throw new RuntimeException(e);
        }
    }

    private void deconfigureJMX() {
        this.jmxConfigurator.onStop(null);
    }
}

