/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine.liquibase;

import java.sql.SQLException;
import javax.inject.Inject;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;

public class LiquibaseFacade {
    private static final String BEFORE_LAST_UPDATE = "BEFORE_LAST_UPDATE";
    private final DataSource dataSource;

    @Inject
    public LiquibaseFacade(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void migrate(String changelog) {
        this.migrate(changelog, null);
    }

    public void migrate(String changelog, String contexts) {
        ClassLoaderResourceAccessor resourceAccessor = new ClassLoaderResourceAccessor();
        JdbcConnection databaseConnection = null;
        changelog = this.normalizeName(changelog);
        try {
            databaseConnection = new JdbcConnection(this.dataSource.getConnection());
            Liquibase liquibase = new Liquibase(changelog, (ResourceAccessor)resourceAccessor, (DatabaseConnection)databaseConnection);
            liquibase.tag(BEFORE_LAST_UPDATE);
            liquibase.update(contexts);
        }
        catch (SQLException | LiquibaseException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (databaseConnection != null && !databaseConnection.isClosed()) {
                    databaseConnection.close();
                }
            }
            catch (DatabaseException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void rollbackLastUpdate(String changelog) {
        this.rollback(changelog, null, BEFORE_LAST_UPDATE);
    }

    public void rollbackLastUpdate(String changelog, String contexts) {
        this.rollback(changelog, contexts, BEFORE_LAST_UPDATE);
    }

    private void rollback(String changelog, String contexts, String tag) {
        changelog = this.normalizeName(changelog);
        ClassLoaderResourceAccessor resourceAccessor = new ClassLoaderResourceAccessor();
        JdbcConnection databaseConnection = null;
        try {
            databaseConnection = new JdbcConnection(this.dataSource.getConnection());
            Liquibase liquibase = new Liquibase(changelog, (ResourceAccessor)resourceAccessor, (DatabaseConnection)databaseConnection);
            liquibase.rollback(tag, contexts);
        }
        catch (SQLException | LiquibaseException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (databaseConnection != null && !databaseConnection.isClosed()) {
                    databaseConnection.close();
                }
            }
            catch (DatabaseException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void dropAll() {
        ClassLoaderResourceAccessor resourceAccessor = new ClassLoaderResourceAccessor();
        JdbcConnection databaseConnection = null;
        try {
            databaseConnection = new JdbcConnection(this.dataSource.getConnection());
            Liquibase liquibase = new Liquibase(null, (ResourceAccessor)resourceAccessor, (DatabaseConnection)databaseConnection);
            liquibase.dropAll();
        }
        catch (SQLException | LiquibaseException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (databaseConnection != null && !databaseConnection.isClosed()) {
                    databaseConnection.close();
                }
            }
            catch (DatabaseException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String normalizeName(String changelog) {
        if (changelog.startsWith("/")) {
            changelog = changelog.substring(1);
        }
        return changelog;
    }
}

