/*
 * Copyright 2011 Atteo.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
package org.atteo.moonshine.jta;

import javax.inject.Singleton;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlRootElement;

import org.atteo.moonshine.TopLevelService;
import org.atteo.moonshine.services.ImportService;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.matcher.Matchers;

/**
 * Adds support for @Transactional annotation.
 * <p>
 * Provides support for &#064;{@link Transactional} annotation and {@link Transaction} helper.
 * </p>
 */
@XmlRootElement(name = "transactional")
@Singleton
public class TransactionalService extends TopLevelService {
	@XmlIDREF
	@ImportService
	private JtaService jtaService;

	@Override
	public Module configure() {
		return new AbstractModule() {
			@Override
			protected void configure() {
				requestStaticInjection(Transaction.class);
				TransactionalInterceptor interceptor = new TransactionalInterceptor();
				bindInterceptor(Matchers.any(), Matchers.annotatedWith(Transactional.class), interceptor);
				bindInterceptor(Matchers.annotatedWith(Transactional.class), Matchers.any(), interceptor);
			}
		};
	}
}
