/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine.jmx;

import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.xml.bind.annotation.XmlRootElement;
import org.atteo.classindex.ClassIndex;
import org.atteo.moonshine.TopLevelService;
import org.atteo.moonshine.jmx.MBean;

@XmlRootElement(name="jmx")
public class Jmx
extends TopLevelService {
    @Inject
    private Injector injector;
    @Inject
    private MBeanServer server;
    private final List<ObjectName> registeredNames = new ArrayList<ObjectName>();

    public Module configure() {
        return new AbstractModule(){

            protected void configure() {
                this.bind(MBeanServer.class).toInstance((Object)ManagementFactory.getPlatformMBeanServer());
                for (Class klass : ClassIndex.getAnnotated(MBean.class)) {
                    this.bind(klass).in(Singleton.class);
                }
            }
        };
    }

    public void start() {
        try {
            for (Class klass : ClassIndex.getAnnotated(MBean.class)) {
                Object instance = this.injector.getInstance(klass);
                MBean annotation = klass.getAnnotation(MBean.class);
                ObjectName name = annotation != null && !"".equals(annotation.name()) ? ObjectName.getInstance(annotation.name()) : ObjectName.getInstance(klass.getPackage().getName() + ":type=" + klass.getSimpleName());
                ObjectInstance mbeanInstance = this.server.registerMBean(instance, name);
                this.registeredNames.add(mbeanInstance.getObjectName());
            }
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        for (ObjectName name : this.registeredNames) {
            try {
                this.server.unregisterMBean(name);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
            }
            catch (MBeanRegistrationException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

