/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine.jmx;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class JmxUtils {
    public static long getVirtualMachinePid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        return Long.parseLong(name.substring(0, name.indexOf(64)));
    }

    public static JMXServiceURL attachToJMX(Long pid) {
        VirtualMachine vm;
        String CONNECTOR_ADDRESS = "com.sun.management.jmxremote.localConnectorAddress";
        try {
            vm = VirtualMachine.attach(pid.toString());
        }
        catch (AttachNotSupportedException | IOException e) {
            throw new RuntimeException(e);
        }
        try {
            String connectorAddress = vm.getAgentProperties().getProperty(CONNECTOR_ADDRESS);
            if (connectorAddress == null) {
                String agent = vm.getSystemProperties().getProperty("java.home") + File.separator + "lib" + File.separator + "management-agent.jar";
                vm.loadAgent(agent);
                connectorAddress = vm.getAgentProperties().getProperty(CONNECTOR_ADDRESS);
            }
            JMXServiceURL jMXServiceURL = new JMXServiceURL(connectorAddress);
            return jMXServiceURL;
        }
        catch (AgentInitializationException | AgentLoadException | IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                vm.detach();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static JMXConnector connectToItself() throws IOException {
        return JMXConnectorFactory.connect(JmxUtils.attachToJMX(JmxUtils.getVirtualMachinePid()));
    }
}

