/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine.jmx;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import java.util.Map;
import javax.inject.Inject;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;
import org.atteo.moonshine.jmx.MBean;

@MBean
public class GuiceBindings
implements DynamicMBean {
    private Injector injector;

    @Inject
    private void setInjector(Injector injector) {
        this.injector = injector.getParent();
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        for (Map.Entry entry : this.injector.getAllBindings().entrySet()) {
            Key key = (Key)entry.getKey();
            Binding binding = (Binding)entry.getValue();
            if (!attribute.equals(key.toString())) continue;
            return binding.getProvider().toString() + " at " + binding.getSource().toString();
        }
        return null;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList(this.injector.getAllBindings().size());
        for (Map.Entry entry : this.injector.getAllBindings().entrySet()) {
            Key key = (Key)entry.getKey();
            list.add(new Attribute(key.toString(), key));
        }
        return list;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[this.injector.getAllBindings().size()];
        int i = 0;
        for (Map.Entry entry : this.injector.getAllBindings().entrySet()) {
            Key key = (Key)entry.getKey();
            attributes[i] = new MBeanAttributeInfo(key.toString(), "java.lang.String", "Key " + key.toString(), true, false, false);
            ++i;
        }
        return new MBeanInfo(GuiceBindings.class.getName(), "Guice Bindings", attributes, null, null, null);
    }
}

