/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine.jmx;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.atteo.moonshine.TopLevelService;
import org.atteo.moonshine.jmx.RmiRegistryPort;
import sun.rmi.registry.RegistryImpl;
import sun.rmi.server.UnicastRef;

@XmlRootElement(name="rmiRegistry")
public class RmiRegistry
extends TopLevelService {
    @XmlElement
    private int rmiRegistryPort = 0;

    public Module configure() {
        return new AbstractModule(){

            protected void configure() {
                Registry registry;
                try {
                    registry = LocateRegistry.createRegistry(RmiRegistry.this.rmiRegistryPort);
                }
                catch (RemoteException e) {
                    throw new RuntimeException("Cannot create RMI registry on port: " + RmiRegistry.this.rmiRegistryPort, e);
                }
                UnicastRef ref = (UnicastRef)((RegistryImpl)registry).getRef();
                final int port = ref.getLiveRef().getPort();
                RmiRegistryPort portProvider = new RmiRegistryPort(){

                    @Override
                    public int getPort() {
                        return port;
                    }
                };
                if (RmiRegistry.this.getId() != null) {
                    this.bind(RmiRegistryPort.class).annotatedWith((Annotation)Names.named((String)RmiRegistry.this.getId())).toInstance((Object)portProvider);
                } else {
                    this.bind(RmiRegistryPort.class).toInstance((Object)portProvider);
                }
            }
        };
    }
}

