/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine.jetty.handlers;

import com.google.inject.Module;
import java.util.Collections;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlRootElement;
import org.atteo.moonshine.jetty.handlers.HandlerConfig;
import org.atteo.moonshine.services.ImportService;
import org.atteo.moonshine.services.Service;
import org.atteo.moonshine.webserver.ServletContainer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;

@XmlRootElement(name="servlets")
public class ServletContextHandlerConfig
extends HandlerConfig
implements Service {
    @ImportService
    @XmlElement
    @XmlIDREF
    private ServletContainer servletContainer;

    @Override
    public Handler getHandler() {
        final ServletContextHandler handler = new ServletContextHandler();
        handler.addLifeCycleListener((LifeCycle.Listener)new AbstractLifeCycle.AbstractLifeCycleListener(){

            public void lifeCycleStarting(LifeCycle event) {
                handler.getServletContext().setExtendedListenerTypes(true);
                Iterable initializers = ServletContextHandlerConfig.this.servletContainer.getInitializers();
                for (ServletContainerInitializer servletContainerInitializer : initializers) {
                    try {
                        servletContainerInitializer.onStartup(Collections.emptySet(), (ServletContext)handler.getServletContext());
                    }
                    catch (ServletException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                handler.addServlet(DefaultServlet.class, "/");
                handler.getServletContext().setExtendedListenerTypes(false);
            }
        });
        return handler;
    }

    public Module configure() {
        return null;
    }

    public void start() {
    }

    public void stop() {
    }

    public void close() {
    }

    public Iterable<? extends Service> getSubServices() {
        return Collections.emptyList();
    }
}

