/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine.jetty.handlers;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.atteo.moonshine.jetty.handlers.HandlerConfig;
import org.atteo.moonshine.jetty.handlers.ResourceHandlerMimeTypeConfig;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.ResourceHandler;

@XmlRootElement(name="resource")
public class ResourceHandlerConfig
extends HandlerConfig {
    @XmlElement
    private boolean directoriesListed = false;
    @XmlElementWrapper(name="welcomeFiles")
    @XmlElement(name="welcomeFile")
    private String[] welcomeFiles = new String[]{"index.html"};
    @XmlElementWrapper(name="mimeTypes")
    @XmlElementRef
    private ResourceHandlerMimeTypeConfig[] mimeTypes = new ResourceHandlerMimeTypeConfig[0];
    @XmlElement
    private String resourceBase;

    @Override
    public Handler getHandler() {
        ResourceHandler handler = new ResourceHandler();
        handler.setDirectoriesListed(this.directoriesListed);
        handler.setWelcomeFiles(this.welcomeFiles);
        for (ResourceHandlerMimeTypeConfig mimeType : this.mimeTypes) {
            handler.getMimeTypes().addMimeMapping(mimeType.getExtension(), mimeType.getName());
        }
        if (this.resourceBase != null) {
            handler.setResourceBase(this.resourceBase);
        }
        return handler;
    }
}

