/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine.jetty.connectors;

import java.io.File;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.atteo.config.Configurable;
import org.atteo.config.XmlDefaultValue;
import org.atteo.moonshine.webserver.crypto.Crypto;
import org.eclipse.jetty.util.ssl.SslContextFactory;

@XmlRootElement(name="sslcontextfactory")
public class SslContextFactoryConfig
extends Configurable {
    @XmlElement
    @XmlDefaultValue(value="${configHome}/keystore.jks")
    private String keyStorePath;
    @XmlElement
    private String keyStorePassword = "secret";
    @XmlElement
    @XmlDefaultValue(value="default")
    private String keyAlias;
    @XmlElement
    @XmlDefaultValue(value="${configHome}/truststore.jks")
    private String trustStoreLocation;
    @XmlElement
    private String trustStorePassword = "secret";
    @XmlElement
    private boolean needClientAuth = false;
    @XmlElement
    private boolean wantClientAuth = false;

    public SslContextFactory getSslContextFactory() {
        SslContextFactory factory = new SslContextFactory(true);
        File keyStoreFile = new File(this.keyStorePath);
        if (!keyStoreFile.exists()) {
            Crypto.createSelfSignedCertificate((File)keyStoreFile, (String)this.keyAlias, (String)this.keyStorePassword);
        }
        factory.setKeyStorePath(this.keyStorePath);
        factory.setKeyStorePassword(this.keyStorePassword);
        factory.setCertAlias(this.keyAlias);
        File trustStoreFile = new File(this.trustStoreLocation);
        if (trustStoreFile.exists()) {
            factory.setTrustStorePath(this.trustStoreLocation);
        }
        factory.setTrustStorePassword(this.trustStorePassword);
        factory.setNeedClientAuth(this.needClientAuth);
        factory.setWantClientAuth(this.wantClientAuth);
        return factory;
    }
}

