/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine.jetty;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.management.MBeanServer;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.atteo.moonshine.ServiceConfiguration;
import org.atteo.moonshine.jetty.connectors.AbstractNetworkConnectorConfig;
import org.atteo.moonshine.jetty.connectors.ConnectorConfig;
import org.atteo.moonshine.jetty.connectors.ServerConnectorConfig;
import org.atteo.moonshine.jetty.connectors.SslContextFactoryConfig;
import org.atteo.moonshine.jetty.handlers.HandlerConfig;
import org.atteo.moonshine.jetty.handlers.ServletContextHandlerConfig;
import org.atteo.moonshine.services.Service;
import org.atteo.moonshine.webserver.WebServerService;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="jetty")
@ServiceConfiguration(autoConfiguration="<connectors>    <serverconnector>        <provideAddress>true</provideAddress>        <host>${oneof:${jetty.host},${webserver.host},}</host>        <port>${oneof:${jetty.port},${webserver.host},}</port>    </serverconnector></connectors>")
public class Jetty
extends WebServerService {
    @XmlElementWrapper(name="sslcontextfactories")
    @XmlElementRef
    private SslContextFactoryConfig[] sslContextFactories;
    @XmlElementWrapper(name="connectors")
    @XmlElementRef
    private ConnectorConfig[] connectors = new ConnectorConfig[]{new ServerConnectorConfig(true)};
    @XmlElementRef
    private HandlerConfig handler = new ServletContextHandlerConfig();
    @Inject(optional=true)
    private MBeanServer mbeanServer;
    private Server server;

    private static void addRecursively(List<Service> handlerServices, HandlerConfig handler) {
        if (handler instanceof Service) {
            handlerServices.add((Service)handler);
        }
        for (HandlerConfig subHandler : handler.getSubHandlers()) {
            Jetty.addRecursively(handlerServices, subHandler);
        }
    }

    public Iterable<? extends Service> getSubServices() {
        ArrayList<Service> handlerServices = new ArrayList<Service>();
        Jetty.addRecursively(handlerServices, this.handler);
        return Iterables.concat(Arrays.asList(this.connectors), handlerServices);
    }

    public void start() {
        this.server = new Server();
        this.server.setHandler(this.handler.getHandler());
        for (ConnectorConfig config : this.connectors) {
            this.server.addConnector(config.getConnector(this.server));
        }
        if (this.mbeanServer != null) {
            MBeanContainer mbContainer = new MBeanContainer(this.mbeanServer);
            this.server.addBean((Object)mbContainer);
            this.server.addBean((Object)Log.getLog());
        }
        try {
            this.server.start();
            this.printPorts();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        if (this.server == null) {
            return;
        }
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void printPorts() {
        Logger logger = LoggerFactory.getLogger((String)"Moonshine");
        for (ConnectorConfig config : this.connectors) {
            if (!(config instanceof AbstractNetworkConnectorConfig)) continue;
            AbstractNetworkConnectorConfig networkConfig = (AbstractNetworkConnectorConfig)config;
            String host = networkConfig.getHost();
            if (host == null) {
                host = "0.0.0.0";
            }
            logger.info("    Jetty connector started on {}:{}", (Object)host, (Object)networkConfig.getPort());
        }
    }
}

