/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine.jetty.connectors;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.atteo.moonshine.jetty.connectors.AbstractNetworkConnectorConfig;
import org.atteo.moonshine.jetty.connectors.ConnectionFactoryConfig;
import org.atteo.moonshine.jetty.connectors.HttpConnectionFactoryConfig;
import org.atteo.moonshine.webserver.WebServerAddress;
import org.eclipse.jetty.server.AbstractNetworkConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;

@XmlRootElement(name="serverconnector")
public class ServerConnectorConfig
extends AbstractNetworkConnectorConfig {
    @XmlElementWrapper(name="connections")
    @XmlElementRef
    private ConnectionFactoryConfig[] connections = new ConnectionFactoryConfig[]{new HttpConnectionFactoryConfig()};
    @XmlElement
    private boolean provideAddress = false;

    @Override
    public AbstractNetworkConnector createConnector(Server server) {
        ConnectionFactory[] connectionFactories = new ConnectionFactory[this.connections.length];
        int i = 0;
        for (ConnectionFactoryConfig connectionConfig : this.connections) {
            connectionFactories[i] = connectionConfig.getConnectionFactory();
            ++i;
        }
        return new ServerConnector(server, connectionFactories);
    }

    public Module configure() {
        return new AbstractModule(){

            protected void configure() {
                if (ServerConnectorConfig.this.provideAddress) {
                    this.bind(WebServerAddress.class).toInstance((Object)ServerConnectorConfig.this.getWebServerAddress());
                }
            }
        };
    }

    private WebServerAddress getWebServerAddress() {
        return new WebServerAddress(){

            public int getPort() {
                return ServerConnectorConfig.this.getPort();
            }

            public String getHost() {
                return ServerConnectorConfig.this.getHost();
            }

            public String getUrl() {
                String host = ServerConnectorConfig.this.getHost();
                if (host == null) {
                    host = "localhost";
                }
                return ServerConnectorConfig.this.connections[0].getProtocolString() + "://" + host + ":" + ServerConnectorConfig.this.getPort();
            }
        };
    }
}

