/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine.jersey;

import com.google.inject.Module;
import com.google.inject.PrivateModule;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import java.util.HashMap;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlRootElement;
import org.atteo.evo.classindex.ClassIndex;
import org.atteo.moonshine.TopLevelService;
import org.atteo.moonshine.services.ImportService;
import org.atteo.moonshine.webserver.ServletContainer;

@XmlRootElement(name="jersey")
public class Jersey
extends TopLevelService {
    @XmlElement
    @XmlIDREF
    @ImportService
    private ServletContainer servletContainer;
    @XmlElement
    private String prefix = "/";
    @XmlElement
    private boolean discoverResources = true;
    @XmlElement
    private boolean formatOutput = false;

    public Module configure() {
        return new PrivateModule(){

            protected void configure() {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("com.sun.jersey.config.feature.FilterForwardOn404", "true");
                if (Jersey.this.formatOutput) {
                    params.put("com.sun.jersey.config.feature.Formatted", "true");
                }
                params.put("com.sun.jersey.config.feature.FilterContextPath", Jersey.this.prefix);
                params.put("com.sun.jersey.freemarker.templateBasePath", "templates");
                this.bind(GuiceContainer.class);
                Jersey.this.servletContainer.addFilter((javax.inject.Provider)this.getProvider(GuiceContainer.class), params, new String[]{Jersey.this.prefix + "/*"});
                if (Jersey.this.discoverResources) {
                    for (Class klass : ClassIndex.getAnnotated(Path.class)) {
                        this.bind(klass);
                    }
                    for (Class klass : ClassIndex.getAnnotated(Provider.class)) {
                        this.bind(klass);
                    }
                }
            }
        };
    }
}

