/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine.jaxrs;

import com.google.inject.Binder;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.annotation.XmlElement;
import org.atteo.classindex.ClassFilter;
import org.atteo.classindex.ClassIndex;
import org.atteo.moonshine.TopLevelService;

public abstract class Jaxrs
extends TopLevelService {
    @XmlElement
    private boolean discoverResources = false;
    private final List<JaxrsResource<?>> resources = new ArrayList();
    private final List<JaxrsResource<?>> providers = new ArrayList();

    public <T> void registerResource(Class<T> klass, javax.inject.Provider<T> provider) {
        this.resources.add(new JaxrsResource<T>(klass, provider));
    }

    private <T> void registerResource(Class<T> annotated, Binder binder) {
        this.registerResource(annotated, (javax.inject.Provider<T>)binder.getProvider(annotated));
    }

    public <T> void registerProvider(Class<T> klass, javax.inject.Provider<T> provider) {
        this.providers.add(new JaxrsResource<T>(klass, provider));
    }

    protected void registerResources(Binder binder) {
        if (this.discoverResources) {
            for (Class annotated : ClassFilter.only().topLevel().withModifiers(1).from(ClassIndex.getAnnotated(Path.class))) {
                if (annotated.isInterface()) continue;
                binder.bind(annotated);
                this.registerResource(annotated, binder);
            }
        }
    }

    protected void registerProviders(Binder binder) {
        if (this.discoverResources) {
            for (Class annotated : ClassFilter.only().topLevel().withModifiers(1).from(ClassIndex.getAnnotated(Provider.class))) {
                if (annotated.isInterface()) continue;
                binder.bind(annotated);
                this.registerProvider(annotated, (javax.inject.Provider)binder.getProvider(annotated));
            }
        }
    }

    protected List<JaxrsResource<?>> getResources() {
        return this.resources;
    }

    protected List<JaxrsResource<?>> getProviders() {
        return this.providers;
    }

    protected static class JaxrsResource<T> {
        private final Class<T> klass;
        private final javax.inject.Provider<T> provider;

        public JaxrsResource(Class<T> klass, javax.inject.Provider<T> provider) {
            this.klass = klass;
            this.provider = provider;
        }

        public Class<T> getResourceClass() {
            return this.klass;
        }

        public javax.inject.Provider<T> getProvider() {
            return this.provider;
        }
    }
}

