/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine.firebuglogger;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;

public class FireBugAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private static ThreadLocal<HttpServletResponse> response = new ThreadLocal();
    private static ThreadLocal<Integer> headerNumber = new ThreadLocal();
    private PatternLayout layout = new PatternLayout();

    public FireBugAppender() {
        this.layout.setPattern("%d{HH:mm:ss.SSS} [%thread] %-5level %logger{36} - %msg%n");
    }

    public void setContext(Context context) {
        super.setContext(context);
        this.layout.setContext(context);
    }

    public void start() {
        super.start();
        this.layout.start();
    }

    public static void setServletResponse(HttpServletResponse resp) {
        response.set(resp);
        headerNumber.set(0);
    }

    protected void append(ILoggingEvent event) {
        if (response.get() == null) {
            return;
        }
        event.prepareForDeferredProcessing();
        String message = this.layout.doLayout(event);
        String filename = null;
        Integer line = null;
        if (event.hasCallerData()) {
            StackTraceElement callerData = event.getCallerData()[0];
            filename = callerData.getFileName();
            line = callerData.getLineNumber();
        }
        StringWriter writer = new StringWriter();
        try {
            JsonGenerator builder = new JsonFactory().createJsonGenerator((Writer)writer);
            builder.writeStartArray();
            builder.writeStartObject();
            builder.writeFieldName("Type");
            builder.writeString(event.getLevel().toString());
            builder.writeFieldName("File");
            if (filename != null) {
                builder.writeString(filename);
            } else {
                builder.writeNull();
            }
            builder.writeFieldName("Line");
            if (line != null) {
                builder.writeNumber(line.intValue());
            } else {
                builder.writeNull();
            }
            builder.writeFieldName("Label");
            builder.writeString("[S]");
            builder.writeEndObject();
            builder.writeString(message);
            builder.writeEndArray();
            builder.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        HttpServletResponse resp = response.get();
        resp.setHeader("X-Wf-Protocol-1", "http://meta.wildfirehq.org/Protocol/JsonStream/0.2");
        resp.setHeader("X-Wf-1-Plugin-1", "http://meta.firephp.org/Wildfire/Plugin/FirePHP/Library-FirePHPCore/0.3");
        resp.setHeader("X-Wf-1-Structure-1", "http://meta.firephp.org/Wildfire/Structure/FirePHP/FirebugConsole/0.1");
        int number = headerNumber.get();
        int offset = 0;
        int size = writer.getBuffer().length();
        while (size > offset) {
            StringBuilder header = new StringBuilder();
            if (offset == 0) {
                header.append(size);
            }
            header.append("|");
            int end = offset + 4000;
            if (end > size) {
                end = size;
            }
            header.append(writer.getBuffer().substring(offset, end));
            header.append("|");
            offset = end;
            if (offset != size) {
                header.append("\\");
            }
            resp.setHeader("X-Wf-1-1-1-" + number, header.toString());
            ++number;
        }
        headerNumber.set(number);
    }
}

