/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.atteo.moonshine.jta.Transaction;
import org.atteo.moonshine.tests.MoonshineConfiguration;
import org.atteo.moonshine.tests.MoonshineTest;
import org.junit.Test;

@MoonshineConfiguration(fromString="<config>    <atomikos>        <transactionTimeout>5</transactionTimeout>    </atomikos>    <transactional/>    <migration-service/></config>")
public abstract class DatabaseTest
extends MoonshineTest {
    @Inject
    private DataSource dataSource;

    @Test
    public void shouldInjectDataSource() {
        Assertions.assertThat((Object)this.dataSource).isNotNull();
    }

    @Test
    public void shouldSelectJohn() throws SQLException {
        Transaction.require((Transaction.ThrowingRunnable)new Transaction.ThrowingRunnable<SQLException>(){

            public void run() throws SQLException {
                try (Connection connection = DatabaseTest.this.dataSource.getConnection();
                     PreparedStatement statement = connection.prepareStatement("select * from users");
                     ResultSet result = statement.executeQuery();){
                    Assertions.assertThat((boolean)result.next()).isEqualTo(true);
                    Assertions.assertThat((String)result.getString(1)).isEqualTo((Object)"John");
                    Assertions.assertThat((boolean)result.next()).isEqualTo(false);
                }
            }
        });
    }
}

