/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine.tests;

import com.google.common.base.Strings;
import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import javax.sql.DataSource;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.atteo.moonshine.liquibase.LiquibaseFacade;
import org.atteo.moonshine.tests.ChangelogParametersProvider;
import org.atteo.moonshine.tests.Fixture;

public class FixtureInterceptor
implements MethodInterceptor {
    @Inject
    private Injector injector;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        DataSource dataSource;
        Fixture annotation = invocation.getMethod().getAnnotation(Fixture.class);
        String[] fixtureNames = annotation.value();
        String databaseName = annotation.database();
        Class<? extends ChangelogParametersProvider> providerClass = annotation.parametersProvider();
        ChangelogParametersProvider provider = providerClass.newInstance();
        try {
            dataSource = Strings.isNullOrEmpty((String)databaseName) ? (DataSource)this.injector.getInstance(DataSource.class) : (DataSource)this.injector.getInstance(Key.get(DataSource.class, (Annotation)Names.named((String)databaseName)));
        }
        catch (ConfigurationException e) {
            throw new RuntimeException("Cannot find database for annotation " + annotation, e);
        }
        for (int i = 0; i < fixtureNames.length; ++i) {
            if (fixtureNames[i].startsWith("/")) continue;
            fixtureNames[i] = "/" + invocation.getMethod().getDeclaringClass().getPackage().getName().replace('.', '/') + "/" + fixtureNames[i];
        }
        LiquibaseFacade liquibase = new LiquibaseFacade(dataSource);
        for (String fixtureName : fixtureNames) {
            liquibase.migrate(fixtureName, null, provider.getChangelogParameters());
        }
        Object o = null;
        try {
            o = invocation.proceed();
        }
        finally {
            for (int i = fixtureNames.length - 1; i >= 0; --i) {
                liquibase.rollbackLastUpdate(fixtureNames[i], null, provider.getChangelogParameters());
            }
        }
        return o;
    }
}

