/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine.tests;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.matcher.Matchers;
import javax.sql.DataSource;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlRootElement;
import org.aopalliance.intercept.MethodInterceptor;
import org.atteo.moonshine.TopLevelService;
import org.atteo.moonshine.database.DatabaseService;
import org.atteo.moonshine.services.ImportService;
import org.atteo.moonshine.tests.DatabaseCleaner;
import org.atteo.moonshine.tests.Fixture;
import org.atteo.moonshine.tests.FixtureInterceptor;

@XmlRootElement(name="database-tests")
public class DatabaseTestUtilities
extends TopLevelService {
    @ImportService
    @XmlIDREF
    @XmlElement(name="database")
    private DatabaseService database;

    public Module configure() {
        return new AbstractModule(){

            protected void configure() {
                this.bind(DatabaseCleaner.class).toProvider((Provider)new Provider<DatabaseCleaner>(){
                    @Inject
                    private DataSource dataSource;

                    public DatabaseCleaner get() {
                        return new DatabaseCleaner(this.dataSource, DatabaseTestUtilities.this.database);
                    }
                }).in(Scopes.SINGLETON);
                FixtureInterceptor interceptor = new FixtureInterceptor();
                this.requestInjection(interceptor);
                this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(Fixture.class), new MethodInterceptor[]{interceptor});
            }
        };
    }
}

