/*
 * Copyright 2011 Atteo.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.atteo.moonshine.tests;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import javax.sql.DataSource;


/**
 * Executes given Liquibase migration on the given database.
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface Fixture {
	/**
	 * Names of the resources containing migrations.
	 */
	String[] value();

	/**
	 * Database ID.
	 * <p>
	 * {@link DataSource} bound with this ID will be used to execute migration.
	 * </p>
	 */
	String database() default "";

	/**
	 * Changelog parameters provider
	 */
	Class<? extends ChangelogParametersProvider> parametersProvider() default EmptyChangelogParametersProvider.class;


}
