/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine.tests;

import com.google.common.base.Strings;
import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import javax.sql.DataSource;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.atteo.moonshine.liquibase.LiquibaseFacade;
import org.atteo.moonshine.tests.Fixture;

public class FixtureInterceptor
implements MethodInterceptor {
    @Inject
    private Injector injector;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        DataSource dataSource;
        Fixture annotation = invocation.getMethod().getAnnotation(Fixture.class);
        String fixtureName = annotation.value();
        String databaseName = annotation.database();
        try {
            dataSource = Strings.isNullOrEmpty((String)databaseName) ? (DataSource)this.injector.getInstance(DataSource.class) : (DataSource)this.injector.getInstance(Key.get(DataSource.class, (Annotation)Names.named((String)databaseName)));
        }
        catch (ConfigurationException e) {
            throw new RuntimeException("Cannot find database for annotation " + annotation, e);
        }
        if (!fixtureName.startsWith("/")) {
            fixtureName = "/" + invocation.getMethod().getDeclaringClass().getPackage().getName().replace('.', '/') + "/" + fixtureName;
        }
        LiquibaseFacade liquibase = new LiquibaseFacade(dataSource);
        liquibase.migrate(fixtureName);
        Object o = null;
        try {
            o = invocation.proceed();
        }
        finally {
            liquibase.rollbackLastUpdate(fixtureName);
        }
        return o;
    }
}

