/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine.tests;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.atteo.moonshine.database.DatabaseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseCleaner {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseCleaner.class);
    private final DataSource dataSource;
    private final DatabaseService database;

    public DatabaseCleaner(DataSource dataSource, DatabaseService database) {
        this.dataSource = dataSource;
        this.database = database;
    }

    public void reset() {
        this.dropTables();
        this.database.executeMigrations(this.dataSource);
    }

    public void clean() {
        logger.debug("Clearing database");
        try (Connection connection = this.dataSource.getConnection();){
            List<String> tables = this.analyseDatabase(connection);
            this.clearTables(connection, tables);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void dropTables() {
        try (Connection connection = this.dataSource.getConnection();){
            List<String> tables = this.analyseDatabase(connection);
            this.dropTables(connection, tables);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private List<String> analyseDatabase(Connection connection) {
        try {
            ArrayList<String> tables = new ArrayList<String>();
            DatabaseMetaData metaData = connection.getMetaData();
            try (ResultSet result = metaData.getTables(null, null, "%", new String[]{"TABLE"});){
                while (result.next()) {
                    String tableName = result.getString("TABLE_NAME");
                    tables.add(tableName);
                }
            }
            return tables;
        }
        catch (SQLException e) {
            throw new RuntimeException("An exception occurred while trying to analyse the database.", e);
        }
    }

    private void clearTables(Connection connection, List<String> tables) {
        for (String table : tables) {
            if (table.equals("DATABASECHANGELOG") || table.equals("DATABASECHANGELOGLOCK")) continue;
            this.clearSingleTable(connection, table);
        }
    }

    private void clearSingleTable(Connection connection, String tableName) {
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate("DELETE FROM " + tableName);
        }
        catch (SQLException ex) {
            throw new RuntimeException("Can't read table contents from table ".concat(tableName), ex);
        }
    }

    private void dropTables(Connection connection, List<String> tables) {
        for (String table : tables) {
            this.dropTable(connection, table);
        }
    }

    private void dropTable(Connection connection, String tableName) {
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate("DROP TABLE " + tableName);
        }
        catch (SQLException ex) {
            throw new RuntimeException("Can't read table contents from table ".concat(tableName), ex);
        }
    }
}

