/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine.tests;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseCleaner {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseCleaner.class);

    public static void clean(DataSource dataSource) {
        logger.debug("Clearing database");
        try (Connection connection = dataSource.getConnection();){
            List<String> tables = DatabaseCleaner.analyseDatabase(connection);
            DatabaseCleaner.clearTables(connection, tables);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<String> analyseDatabase(Connection connection) {
        try {
            ArrayList<String> tables = new ArrayList<String>();
            DatabaseMetaData metaData = connection.getMetaData();
            try (ResultSet result = metaData.getTables(null, null, "%", new String[]{"TABLE"});){
                while (result.next()) {
                    String tableName = result.getString("TABLE_NAME");
                    if (tableName.equals("DATABASECHANGELOG") || tableName.equals("DATABASECHANGELOGLOCK")) continue;
                    tables.add(tableName);
                }
            }
            return tables;
        }
        catch (SQLException e) {
            throw new RuntimeException("An exception occurred while trying to analyse the database.", e);
        }
    }

    private static void clearTables(Connection connection, List<String> tables) {
        for (String table : tables) {
            DatabaseCleaner.clearSingleTable(connection, table);
        }
    }

    private static void clearSingleTable(Connection connection, String tableName) {
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate("DELETE FROM " + tableName);
        }
        catch (SQLException ex) {
            throw new RuntimeException("Can't read table contents from table ".concat(tableName), ex);
        }
    }
}

