/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine.atomikos;

import com.atomikos.icatch.SysException;
import com.atomikos.icatch.config.UserTransactionServiceImp;
import com.atomikos.icatch.jta.UserTransactionManager;
import com.atomikos.icatch.standalone.UserTransactionServiceFactory;
import com.atomikos.jdbc.AtomikosDataSourceBean;
import com.atomikos.jms.AtomikosConnectionFactoryBean;
import com.google.inject.Module;
import com.google.inject.PrivateModule;
import com.google.inject.Provider;
import java.lang.management.ManagementFactory;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.jms.ConnectionFactory;
import javax.jms.XAConnectionFactory;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.atteo.config.XmlDefaultValue;
import org.atteo.moonshine.jta.JtaConnectionFactoryWrapper;
import org.atteo.moonshine.jta.JtaDataSourceWrapper;
import org.atteo.moonshine.jta.JtaService;
import org.atteo.moonshine.jta.PoolOptions;

@XmlRootElement(name="atomikos")
public class Atomikos
extends JtaService {
    @XmlElement
    private Integer maxActiveTransactions = -1;
    @XmlElement
    @XmlDefaultValue(value="${dataHome}/atomikos/logs")
    private String logDirectory;
    @XmlElement
    @XmlDefaultValue(value="${dataHome}/atomikos/")
    private String consoleOutputDirectory;
    @XmlElement
    @XmlDefaultValue(value="60")
    private Integer transactionTimeout;
    private UserTransactionManager manager;
    private UserTransactionServiceImp service;

    public Module configure() {
        return new PrivateModule(){

            protected void configure() {
                this.bind(UserTransactionManager.class).toProvider((Provider)new ManagerProvider()).in(Singleton.class);
                this.bind(TransactionManager.class).to(UserTransactionManager.class);
                this.expose(TransactionManager.class);
                this.bind(UserTransaction.class).to(UserTransactionManager.class);
                this.expose(UserTransaction.class);
                this.bind(JtaDataSourceWrapper.class).to(AtomikosDataSourceWrapper.class).in(Singleton.class);
                this.expose(JtaDataSourceWrapper.class);
                this.bind(JtaConnectionFactoryWrapper.class).to(AtomikosConnectionFactoryWrapper.class).in(Singleton.class);
                this.expose(JtaConnectionFactoryWrapper.class);
            }
        };
    }

    public void close() {
        if (this.manager != null) {
            this.manager.close();
        }
        if (this.service != null) {
            this.service.shutdownWait();
        }
    }

    private static class AtomikosConnectionFactoryWrapper
    implements JtaConnectionFactoryWrapper {
        private AtomikosConnectionFactoryWrapper() {
        }

        public ConnectionFactory wrap(String name, XAConnectionFactory xaFactory, PoolOptions poolOptions) {
            AtomikosConnectionFactoryBean wrapped = new AtomikosConnectionFactoryBean();
            wrapped.setXaConnectionFactory(xaFactory);
            wrapped.setUniqueResourceName(name);
            if (poolOptions == null) {
                return wrapped;
            }
            if (poolOptions.getMinPoolSize() != null) {
                wrapped.setMinPoolSize(poolOptions.getMinPoolSize().intValue());
            }
            if (poolOptions.getMaxPoolSize() != null) {
                wrapped.setMaxPoolSize(poolOptions.getMaxPoolSize().intValue());
            }
            if (poolOptions.getMaxIdleTime() != null) {
                wrapped.setMaxIdleTime(poolOptions.getMaxIdleTime().intValue());
            }
            if (poolOptions.getReapTimeout() != null) {
                wrapped.setReapTimeout(poolOptions.getReapTimeout().intValue());
            }
            return wrapped;
        }

        public void close(ConnectionFactory connectionFactory) {
            ((AtomikosConnectionFactoryBean)connectionFactory).close();
        }
    }

    private static class AtomikosDataSourceWrapper
    implements JtaDataSourceWrapper {
        @Inject
        UserTransactionManager userTransactionManager;

        private AtomikosDataSourceWrapper() {
        }

        public DataSource wrap(String name, XADataSource xaDataSource, PoolOptions poolOptions, String testQuery) {
            AtomikosDataSourceBean wrapped = new AtomikosDataSourceBean();
            wrapped.setXaDataSource(xaDataSource);
            wrapped.setUniqueResourceName(name);
            if (poolOptions == null) {
                poolOptions = new PoolOptions();
            }
            if (poolOptions.getMaxLifeTime() != null && poolOptions.getMaxLifeTime() != 0) {
                wrapped.setMaxLifetime(poolOptions.getMaxLifeTime().intValue());
            } else {
                wrapped.setTestQuery(testQuery);
            }
            if (poolOptions.getMinPoolSize() != null) {
                wrapped.setMinPoolSize(poolOptions.getMinPoolSize().intValue());
            }
            if (poolOptions.getMaxPoolSize() != null) {
                wrapped.setMaxPoolSize(poolOptions.getMaxPoolSize().intValue());
            }
            if (poolOptions.getMaxIdleTime() != null) {
                wrapped.setMaxIdleTime(poolOptions.getMaxIdleTime().intValue());
            }
            if (poolOptions.getReapTimeout() != null) {
                wrapped.setReapTimeout(poolOptions.getReapTimeout().intValue());
            }
            return wrapped;
        }

        public void close(DataSource dataSource) {
            ((AtomikosDataSourceBean)dataSource).close();
        }
    }

    public class ManagerProvider
    implements Provider<UserTransactionManager> {
        public UserTransactionManager get() {
            System.setProperty("com.atomikos.icatch.no_file", "true");
            System.setProperty("com.atomikos.icatch.hide_init_file_path", "true");
            System.setProperty("com.atomikos.icatch.service", UserTransactionServiceFactory.class.getCanonicalName());
            Properties properties = new Properties();
            properties.setProperty("com.atomikos.icatch.max_actives", Integer.toString(Atomikos.this.maxActiveTransactions));
            properties.setProperty("com.atomikos.icatch.tm_unique_name", "TM_" + ManagementFactory.getRuntimeMXBean().getName());
            properties.setProperty("com.atomikos.icatch.log_base_name", "log_");
            properties.setProperty("com.atomikos.icatch.log_base_dir", Atomikos.this.logDirectory);
            properties.setProperty("com.atomikos.icatch.output_dir", Atomikos.this.consoleOutputDirectory);
            properties.setProperty("com.atomikos.icatch.threaded_2pc", "false");
            properties.setProperty("com.atomikos.icatch.default_jta_timeout", Integer.toString(Atomikos.this.transactionTimeout * 1000));
            Atomikos.this.service = new UserTransactionServiceImp(properties);
            try {
                Atomikos.this.service.init();
            }
            catch (SysException e) {
                throw new RuntimeException(((Exception)e.getErrors().pop()).toString(), e);
            }
            Atomikos.this.manager = new UserTransactionManager();
            Atomikos.this.manager.setStartupTransactionService(false);
            try {
                Atomikos.this.manager.init();
            }
            catch (SystemException e) {
                throw new RuntimeException(e);
            }
            return Atomikos.this.manager;
        }
    }
}

