/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.dollarbrace.janino;

import java.lang.reflect.InvocationTargetException;
import org.atteo.dollarbrace.PrefixedPropertyResolver;
import org.atteo.dollarbrace.PropertyFilter;
import org.atteo.dollarbrace.PropertyNotFoundException;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.ExpressionEvaluator;

public class JaninoPropertyResolver
implements PrefixedPropertyResolver {
    private static final String prefix = "java:";
    private boolean useWithoutPrefix = false;

    public JaninoPropertyResolver() {
    }

    public JaninoPropertyResolver(boolean useWithoutPrefix) {
        this.useWithoutPrefix = useWithoutPrefix;
    }

    public String getPrefix() {
        if (this.useWithoutPrefix) {
            return null;
        }
        return prefix;
    }

    public String resolveProperty(String name, PropertyFilter resolver) throws PropertyNotFoundException {
        boolean throwErrors = false;
        if (name.startsWith(prefix)) {
            name = name.substring(prefix.length());
            throwErrors = true;
        } else if (!this.useWithoutPrefix) {
            throw new PropertyNotFoundException(name);
        }
        name = resolver.filter(name);
        name = name.trim();
        ExpressionEvaluator evaluator = new ExpressionEvaluator();
        evaluator.setExpressionType(Object.class);
        evaluator.setThrownExceptions(new Class[]{Exception.class});
        try {
            evaluator.cook(name);
            return evaluator.evaluate(new Object[0]).toString();
        }
        catch (InvocationTargetException | CompileException e) {
            if (!throwErrors) {
                throw new PropertyNotFoundException(name);
            }
            throw new RuntimeException(e);
        }
    }
}

