/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.config.xmlmerge;

import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.atteo.config.xmlmerge.CombineChildren;
import org.atteo.config.xmlmerge.CombineSelf;
import org.atteo.config.xmlmerge.Context;
import org.atteo.config.xmlmerge.Key;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlCombiner {
    private DocumentBuilder documentBuilder;
    private Document document;

    public XmlCombiner() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        this.documentBuilder = factory.newDocumentBuilder();
        this.document = this.documentBuilder.newDocument();
    }

    public XmlCombiner(DocumentBuilder documentBuilder) {
        this.documentBuilder = documentBuilder;
        this.document = documentBuilder.newDocument();
    }

    public void combine(Document document) {
        this.combine(document.getDocumentElement());
    }

    public void combine(Element element) {
        Element parent = this.document.getDocumentElement();
        if (parent != null) {
            this.document.removeChild(parent);
        }
        Context result = this.combine(Context.fromElement(parent), Context.fromElement(element));
        result.addAsChildTo(this.document);
    }

    public Document buildDocument() {
        XmlCombiner.filterOutDefaults(Context.fromElement(this.document.getDocumentElement()));
        return this.document;
    }

    private Context combine(Context recessive, Context dominant) {
        Key key;
        CombineSelf dominantCombineSelf = XmlCombiner.getCombineSelf(dominant.getElement());
        CombineSelf recessiveCombineSelf = XmlCombiner.getCombineSelf(recessive.getElement());
        if (dominantCombineSelf == CombineSelf.REMOVE) {
            return null;
        }
        if (dominantCombineSelf == CombineSelf.OVERRIDE) {
            Context result = this.copyRecursively(dominant);
            result.getElement().removeAttribute("combine.self");
            return result;
        }
        CombineChildren combineChildren = XmlCombiner.getCombineChildren(dominant.getElement());
        if (combineChildren == null && (combineChildren = XmlCombiner.getCombineChildren(recessive.getElement())) == null) {
            combineChildren = CombineChildren.MERGE;
        }
        if (combineChildren == CombineChildren.APPEND) {
            if (recessive.getElement() != null) {
                XmlCombiner.removeWhitespaceTail(recessive.getElement());
                this.appendRecursively(dominant, recessive);
                return recessive;
            }
            return this.copyRecursively(dominant);
        }
        Element resultElement = this.document.createElement(dominant.getElement().getTagName());
        this.copyAttributes(recessive.getElement(), resultElement);
        this.copyAttributes(dominant.getElement(), resultElement);
        CombineSelf combineSelf = dominantCombineSelf;
        if (combineSelf == null && recessiveCombineSelf != CombineSelf.DEFAULTS) {
            combineSelf = recessiveCombineSelf;
        }
        if (combineSelf != null) {
            resultElement.setAttribute("combine.self", combineSelf.name().toLowerCase());
        } else {
            resultElement.removeAttribute("combine.self");
        }
        ListMultimap<Key, Context> recessiveContexts = recessive.mapChildContexts();
        ListMultimap<Key, Context> dominantContexts = dominant.mapChildContexts();
        if (!recessiveContexts.isEmpty()) {
            for (Map.Entry entry : recessiveContexts.entries()) {
                key = (Key)entry.getKey();
                Context recessiveContext = (Context)entry.getValue();
                if (key == Key.BEFORE_END) continue;
                if (dominantContexts.get((Object)key).size() == 1 && recessiveContexts.get((Object)key).size() == 1) {
                    Context dominantContext = (Context)dominantContexts.get((Object)key).iterator().next();
                    Context combined = this.combine(recessiveContext, dominantContext);
                    if (combined == null) continue;
                    combined.addAsChildTo(resultElement);
                    continue;
                }
                recessiveContext.addAsChildTo(resultElement);
            }
        }
        for (Map.Entry entry : dominantContexts.entries()) {
            Context combined;
            key = (Key)entry.getKey();
            Context dominantContext = (Context)entry.getValue();
            if (key == Key.BEFORE_END) {
                dominantContext.addAsChildTo(resultElement, this.document);
                continue;
            }
            if (dominantContexts.get((Object)key).size() == 1 && recessiveContexts.get((Object)key).size() == 1 || (combined = this.combine(Context.fromElement(null), dominantContext)) == null) continue;
            combined.addAsChildTo(resultElement);
        }
        Context result = new Context();
        result.setElement(resultElement);
        this.appendNeighbours(dominant, result);
        return result;
    }

    private Context copyRecursively(Context context) {
        Context copy = new Context();
        this.appendNeighbours(context, copy);
        Element element = (Element)this.document.importNode(context.getElement(), false);
        copy.setElement(element);
        this.appendRecursively(context, copy);
        return copy;
    }

    private void appendNeighbours(Context source, Context destination) {
        for (Node neighbour : source.getNeighbours()) {
            destination.addNeighbour(this.document.importNode(neighbour, true));
        }
    }

    private void appendRecursively(Context source, Context destination) {
        this.copyAttributes(source.getElement(), destination.getElement());
        List<Context> contexts = source.groupChildContexts();
        for (Context context : contexts) {
            if (context.getElement() == null) {
                context.addAsChildTo(destination.getElement(), this.document);
                continue;
            }
            Context combined = this.combine(Context.fromElement(null), context);
            if (combined == null) continue;
            combined.addAsChildTo(destination.getElement());
        }
    }

    private void copyAttributes(@Nullable Element source, Element destination) {
        if (source == null) {
            return;
        }
        NamedNodeMap attributes = source.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            Attr destAttribute = destination.getAttributeNodeNS(attribute.getNamespaceURI(), attribute.getName());
            if (destAttribute == null) {
                destination.setAttributeNodeNS((Attr)this.document.importNode(attribute, true));
                continue;
            }
            destAttribute.setValue(attribute.getValue());
        }
    }

    private static CombineSelf getCombineSelf(@Nullable Element element) {
        CombineSelf combine = null;
        if (element == null) {
            return null;
        }
        Attr combineAttribute = element.getAttributeNode("combine.self");
        if (combineAttribute != null) {
            try {
                combine = CombineSelf.valueOf(combineAttribute.getValue().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("The attribute 'combine' of element '" + element.getTagName() + "' has invalid value '" + combineAttribute.getValue(), e);
            }
        }
        return combine;
    }

    private static CombineChildren getCombineChildren(@Nullable Element element) {
        CombineChildren combine = null;
        if (element == null) {
            return null;
        }
        Attr combineAttribute = element.getAttributeNode("combine.children");
        if (combineAttribute != null) {
            try {
                combine = CombineChildren.valueOf(combineAttribute.getValue().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("The attribute 'combine' of element '" + element.getTagName() + "' has invalid value '" + combineAttribute.getValue(), e);
            }
        }
        return combine;
    }

    private static void removeWhitespaceTail(Element element) {
        Node node;
        NodeList list = element.getChildNodes();
        for (int i = list.getLength() - 1; i >= 0 && !((node = list.item(i)) instanceof Element); --i) {
            element.removeChild(node);
        }
    }

    private static void filterOutDefaults(Context context) {
        Element element = context.getElement();
        List<Context> childContexts = context.groupChildContexts();
        for (Context childContext : childContexts) {
            if (childContext.getElement() == null) continue;
            CombineSelf combineSelf = XmlCombiner.getCombineSelf(childContext.getElement());
            if (combineSelf == CombineSelf.DEFAULTS) {
                for (Node neighbour : childContext.getNeighbours()) {
                    element.removeChild(neighbour);
                }
                element.removeChild(childContext.getElement());
                continue;
            }
            XmlCombiner.filterOutDefaults(childContext);
        }
    }
}

