/*
 * Copyright 2014 Atteo.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.atteo.config.doclet;

import java.io.File;

import org.atteo.config.Configurable;
import static org.atteo.config.doclet.DocletUtils.analyseClass;
import static org.atteo.config.doclet.DocletUtils.documentClass;
import static org.atteo.config.doclet.DocletUtils.isSubclass;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doclet;
import com.sun.javadoc.RootDoc;

public class StandaloneConfigDoclet extends Doclet {
	public static boolean start(RootDoc root) {
		for (ClassDoc klass : root.classes()) {
			// TODO: instead check whether it is reachable from Configurable
			if (isSubclass(klass, Configurable.class)) {
				ClassDescription description = analyseClass(klass);
				String result = documentClass(description, null);

				File file = new File(klass.qualifiedName().replaceAll("\\.", File.separator) + ".html");
            }
        }
		return true;
	}
}
