/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.classindex;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.codehaus.plexus.util.IOUtil;

public class ClassIndexTransformer
implements ResourceTransformer {
    public static final String SUBCLASS_INDEX_PREFIX = "META-INF/services/";
    public static final String ANNOTATED_INDEX_PREFIX = "META-INF/annotations/";
    public static final String PACKAGE_INDEX_NAME = "jaxb.index";
    private ByteArrayOutputStream data;
    private Map serviceEntries = new HashMap();

    public boolean canTransformResource(String resource) {
        if (resource.startsWith(SUBCLASS_INDEX_PREFIX) || resource.startsWith(ANNOTATED_INDEX_PREFIX) || resource.endsWith("/jaxb.index")) {
            this.data = (ByteArrayOutputStream)this.serviceEntries.get(resource);
            if (this.data == null) {
                this.data = new ByteArrayOutputStream();
                this.serviceEntries.put(resource, this.data);
            }
            return true;
        }
        return false;
    }

    public void processResource(String resource, InputStream is, List relocators) throws IOException {
        IOUtil.copy((InputStream)is, (OutputStream)this.data);
        is.close();
    }

    public boolean hasTransformedResource() {
        return this.serviceEntries.size() > 0;
    }

    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        for (String key : this.serviceEntries.keySet()) {
            ByteArrayOutputStream stream = (ByteArrayOutputStream)this.serviceEntries.get(key);
            jos.putNextEntry(new JarEntry(key));
            IOUtil.copy((InputStream)new ByteArrayInputStream(stream.toByteArray()), (OutputStream)jos);
            stream.reset();
        }
    }
}

