/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vibe.transport.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.atmosphere.vibe.platform.action.Action;
import org.atmosphere.vibe.platform.action.Actions;
import org.atmosphere.vibe.platform.action.ConcurrentActions;
import org.atmosphere.vibe.platform.action.VoidAction;
import org.atmosphere.vibe.platform.http.HttpStatus;
import org.atmosphere.vibe.platform.http.ServerHttpExchange;
import org.atmosphere.vibe.transport.BaseServerTransport;
import org.atmosphere.vibe.transport.ServerTransport;
import org.atmosphere.vibe.transport.TransportServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTransportServer
implements TransportServer<ServerHttpExchange> {
    private final Logger log = LoggerFactory.getLogger(HttpTransportServer.class);
    private Actions<ServerTransport> transportActions = new ConcurrentActions().add((Action)new Action<ServerTransport>(){

        public void on(ServerTransport t) {
            final BaseTransport transport = (BaseTransport)t;
            HttpTransportServer.this.log.trace("{}'s request has opened", (Object)transport);
            HttpTransportServer.this.transports.put(transport.id(), transport);
            transport.closeAction((Action<Void>)new VoidAction(){

                public void on() {
                    HttpTransportServer.this.log.trace("{}'s request has been closed", (Object)transport);
                    HttpTransportServer.this.transports.remove(transport.id());
                }
            });
        }
    });
    private Map<String, BaseTransport> transports = new ConcurrentHashMap<String, BaseTransport>();

    public void on(final ServerHttpExchange http) {
        final Map<String, String> params = HttpTransportServer.parseQuery(http.uri());
        block4 : switch (http.method()) {
            case "GET": {
                this.setNocache(http);
                this.setCors(http);
                switch (params.get("when")) {
                    case "open": {
                        String transportName;
                        switch (transportName = params.get("transport")) {
                            case "stream": {
                                this.transportActions.fire((Object)new StreamTransport(http));
                                break block4;
                            }
                            case "longpoll": {
                                this.transportActions.fire((Object)new LongpollTransport(http));
                                break block4;
                            }
                        }
                        this.log.error("Transport, {}, is not implemented", (Object)transportName);
                        http.setStatus(HttpStatus.NOT_IMPLEMENTED).end();
                        break block4;
                    }
                    case "poll": {
                        String id = params.get("id");
                        BaseTransport transport = this.transports.get(id);
                        if (transport != null && transport instanceof LongpollTransport) {
                            ((LongpollTransport)transport).refresh(http);
                            break block4;
                        }
                        this.log.error("Long polling transport#{} is not found", (Object)id);
                        http.setStatus(HttpStatus.INTERNAL_SERVER_ERROR).end();
                        break block4;
                    }
                    case "abort": {
                        String id = params.get("id");
                        BaseTransport transport = this.transports.get(id);
                        if (transport != null) {
                            transport.close();
                        }
                        http.setHeader("content-type", "text/javascript; charset=utf-8").end();
                        break block4;
                    }
                }
                this.log.error("when, {}, is not supported", (Object)params.get("when"));
                http.setStatus(HttpStatus.NOT_IMPLEMENTED).end();
                break;
            }
            case "POST": {
                this.setNocache(http);
                this.setCors(http);
                http.bodyAction((Action)new Action<String>(){

                    public void on(String body) {
                        String data = body.substring("data=".length());
                        String id = (String)params.get("id");
                        BaseTransport transport = (BaseTransport)HttpTransportServer.this.transports.get(id);
                        if (transport != null) {
                            transport.handleText(data);
                        } else {
                            HttpTransportServer.this.log.error("A POST message arrived but no transport#{} is found", (Object)id);
                            http.setStatus(HttpStatus.INTERNAL_SERVER_ERROR);
                        }
                        http.end();
                    }
                }).read();
                break;
            }
            default: {
                this.log.error("HTTP method, {}, is not supported", (Object)http.method());
                http.setStatus(HttpStatus.METHOD_NOT_ALLOWED).end();
            }
        }
    }

    private void setNocache(ServerHttpExchange http) {
        http.setHeader("cache-control", "no-cache, no-store, must-revalidate").setHeader("pragma", "no-cache").setHeader("expires", "0");
    }

    private void setCors(ServerHttpExchange http) {
        String origin = http.header("origin");
        http.setHeader("access-control-allow-origin", origin != null ? origin : "*").setHeader("access-control-allow-credentials", "true");
    }

    public HttpTransportServer transportAction(Action<ServerTransport> action) {
        this.transportActions.add(action);
        return this;
    }

    public static Map<String, String> parseQuery(String uri) {
        String[] params;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String query = URI.create(uri).getQuery();
        if (query == null || query.equals("")) {
            return Collections.unmodifiableMap(map);
        }
        for (String param : params = query.split("&")) {
            try {
                String[] pair = param.split("=", 2);
                String name = URLDecoder.decode(pair[0], "UTF-8");
                if (name.equals("")) continue;
                map.put(name, pair.length > 1 ? URLDecoder.decode(pair[1], "UTF-8") : "");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return Collections.unmodifiableMap(map);
    }

    public static String formatQuery(Map<String, String> params) {
        StringBuilder query = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            try {
                query.append(URLEncoder.encode(entry.getKey(), "UTF-8")).append("=").append(URLEncoder.encode(entry.getValue(), "UTF-8")).append("&");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return query.deleteCharAt(query.length() - 1).toString();
    }

    private static class LongpollTransport
    extends BaseTransport {
        private AtomicReference<ServerHttpExchange> httpRef = new AtomicReference();
        private AtomicBoolean aborted = new AtomicBoolean();
        private AtomicBoolean written = new AtomicBoolean();
        private AtomicReference<Timer> closeTimer = new AtomicReference();
        private Queue<String> cache = new ConcurrentLinkedQueue<String>();
        private ObjectMapper mapper = new ObjectMapper();
        private String jsonpCallback;

        public LongpollTransport(ServerHttpExchange http) {
            super(http);
            this.refresh(http);
            if ("true".equals(this.params.get("jsonp"))) {
                this.jsonpCallback = (String)this.params.get("callback");
            }
            LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
            query.put("id", this.id);
            ((ServerHttpExchange)this.httpRef.getAndSet(null)).end(this.formatMessage("?" + HttpTransportServer.formatQuery(query)));
        }

        public void refresh(ServerHttpExchange http) {
            final Map<String, String> parameters = HttpTransportServer.parseQuery(http.uri());
            http.finishAction((Action)new VoidAction(){

                public void on() {
                    if (((String)parameters.get("when")).equals("poll") && !LongpollTransport.this.written.get()) {
                        LongpollTransport.this.closeActions.fire();
                    } else {
                        Timer timer = new Timer(true);
                        timer.schedule(new TimerTask(){

                            @Override
                            public void run() {
                                LongpollTransport.this.closeActions.fire();
                            }
                        }, 3000L);
                        LongpollTransport.this.closeTimer.set(timer);
                    }
                }
            }).errorAction((Action)new Action<Throwable>(){

                public void on(Throwable throwable) {
                    LongpollTransport.this.errorActions.fire((Object)throwable);
                }
            }).closeAction((Action)new VoidAction(){

                public void on() {
                    LongpollTransport.this.closeActions.fire();
                }
            }).setHeader("content-type", "text/" + (this.jsonpCallback != null ? "javascript" : "plain") + "; charset=utf-8");
            this.httpRef.set(http);
            if (parameters.get("when").equals("poll")) {
                this.written.set(false);
                Timer timer = this.closeTimer.getAndSet(null);
                if (timer != null) {
                    timer.cancel();
                }
                if (this.aborted.get()) {
                    http.end();
                    return;
                }
                String cached = this.cache.poll();
                if (cached != null) {
                    this.send(cached, true);
                }
            }
        }

        @Override
        protected void doSend(String data) {
            this.send(data, false);
        }

        @Override
        protected void doSend(ByteBuffer data) {
            throw new UnsupportedOperationException("Not implemented yet");
        }

        private void send(String data, boolean noCache) {
            ServerHttpExchange http = this.httpRef.getAndSet(null);
            if (http != null) {
                this.written.set(true);
                http.end(this.formatMessage(data));
            } else if (!noCache) {
                this.cache.offer(data);
            }
        }

        private String formatMessage(String data) {
            if (this.jsonpCallback != null) {
                try {
                    return this.jsonpCallback + "(" + this.mapper.writeValueAsString((Object)data) + ");";
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
            return data;
        }

        @Override
        public void doClose() {
            ServerHttpExchange http = this.httpRef.getAndSet(null);
            if (http != null) {
                http.end();
            } else {
                this.aborted.set(true);
            }
        }
    }

    private static class StreamTransport
    extends BaseTransport {
        private static final String text2KB = CharBuffer.allocate(2048).toString().replace('\u0000', ' ');

        public StreamTransport(ServerHttpExchange http) {
            super(http);
            LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
            query.put("id", this.id);
            http.finishAction((Action)new VoidAction(){

                public void on() {
                    StreamTransport.this.closeActions.fire();
                }
            }).errorAction((Action)new Action<Throwable>(){

                public void on(Throwable throwable) {
                    StreamTransport.this.errorActions.fire((Object)throwable);
                }
            }).closeAction((Action)new VoidAction(){

                public void on() {
                    StreamTransport.this.closeActions.fire();
                }
            }).setHeader("content-type", "text/" + ("true".equals(this.params.get("sse")) ? "event-stream" : "plain") + "; charset=utf-8").write(text2KB + "\ndata: ?" + HttpTransportServer.formatQuery(query) + "\n\n");
        }

        @Override
        protected synchronized void doSend(String data) {
            String payload = "";
            for (String line : data.split("\r\n|\r|\n")) {
                payload = payload + "data: " + line + "\n";
            }
            payload = payload + "\n";
            this.http.write(payload);
        }

        @Override
        protected synchronized void doSend(ByteBuffer data) {
            throw new UnsupportedOperationException("Not implemented yet");
        }

        @Override
        public synchronized void doClose() {
            this.http.end();
        }
    }

    private static abstract class BaseTransport
    extends BaseServerTransport {
        protected final String id = UUID.randomUUID().toString();
        protected final ServerHttpExchange http;
        protected final Map<String, String> params;

        public BaseTransport(ServerHttpExchange http) {
            this.params = HttpTransportServer.parseQuery(http.uri());
            this.http = http;
        }

        public String id() {
            return this.id;
        }

        @Override
        public String uri() {
            return this.http.uri();
        }

        public void handleText(String text) {
            this.textActions.fire((Object)text);
        }

        @Override
        public <T> T unwrap(Class<T> clazz) {
            return ServerHttpExchange.class.isAssignableFrom(clazz) ? (T)clazz.cast(this.http) : null;
        }
    }
}

