/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vibe.transport;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;
import org.atmosphere.vibe.platform.action.Action;
import org.atmosphere.vibe.platform.action.Actions;
import org.atmosphere.vibe.platform.action.ConcurrentActions;
import org.atmosphere.vibe.transport.ServerTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseServerTransport
implements ServerTransport {
    protected Actions<String> textActions = new ConcurrentActions();
    protected Actions<ByteBuffer> binaryActions = new ConcurrentActions();
    protected Actions<Throwable> errorActions = new ConcurrentActions().add((Action)new Action<Throwable>(){

        public void on(Throwable throwable) {
            BaseServerTransport.this.logger.trace("{} has received a throwable {}", (Object)BaseServerTransport.this, (Object)throwable);
        }
    });
    protected Actions<Void> closeActions = new ConcurrentActions(new Actions.Options().once(true).memory(true)).add((Action)new Action<Void>(){

        public void on(Void _) {
            BaseServerTransport.this.logger.trace("{} has been closed", (Object)BaseServerTransport.this);
            BaseServerTransport.this.stateRef.set(State.CLOSED);
            BaseServerTransport.this.textActions.disable();
            BaseServerTransport.this.errorActions.disable();
        }
    });
    private final Logger logger = LoggerFactory.getLogger(BaseServerTransport.class);
    private AtomicReference<State> stateRef = new AtomicReference<State>(State.OPEN);

    @Override
    public ServerTransport textAction(Action<String> action) {
        this.textActions.add(action);
        return this;
    }

    @Override
    public ServerTransport binaryAction(Action<ByteBuffer> action) {
        this.binaryActions.add(action);
        return this;
    }

    @Override
    public BaseServerTransport send(String data) {
        this.logger.trace("{} sends a text message {}", (Object)this, (Object)data);
        this.doSend(data);
        return this;
    }

    @Override
    public ServerTransport send(ByteBuffer data) {
        this.logger.trace("{} sends a binary message {}", (Object)this, (Object)data);
        this.doSend(data);
        return this;
    }

    protected abstract void doSend(String var1);

    protected abstract void doSend(ByteBuffer var1);

    @Override
    public ServerTransport errorAction(Action<Throwable> action) {
        this.errorActions.add(action);
        return this;
    }

    @Override
    public ServerTransport closeAction(Action<Void> action) {
        this.closeActions.add(action);
        return this;
    }

    @Override
    public void close() {
        this.logger.trace("{} has started to close the connection", (Object)this);
        State state = this.stateRef.get();
        if (state != State.CLOSING && state != State.CLOSED && this.stateRef.compareAndSet(state, State.CLOSING)) {
            this.doClose();
        }
    }

    protected abstract void doClose();

    static enum State {
        OPEN,
        CLOSING,
        CLOSED;

    }
}

