/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vibe.platform;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.atmosphere.vibe.platform.AbstractActions;
import org.atmosphere.vibe.platform.Action;
import org.atmosphere.vibe.platform.Actions;

public class ConcurrentActions<T>
extends AbstractActions<T> {
    private final AtomicBoolean disabled = new AtomicBoolean();
    private final AtomicBoolean fired = new AtomicBoolean();
    private final AtomicReference<T> cached = new AtomicReference();

    public ConcurrentActions() {
    }

    public ConcurrentActions(Actions.Options o) {
        super(o);
    }

    @Override
    protected List<Action<T>> createList() {
        return new CopyOnWriteArrayList<Action<T>>();
    }

    @Override
    protected void setCache(T data) {
        this.cached.set(data);
    }

    @Override
    protected T cached() {
        return this.cached.get();
    }

    @Override
    protected boolean setDisabled() {
        return this.disabled.compareAndSet(false, true);
    }

    @Override
    public boolean disabled() {
        return this.disabled.get();
    }

    @Override
    protected void setFired() {
        this.fired.set(true);
    }

    @Override
    public boolean fired() {
        return this.fired.get();
    }
}

