/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vibe.platform.server;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import org.atmosphere.vibe.platform.Action;
import org.atmosphere.vibe.platform.Actions;
import org.atmosphere.vibe.platform.HttpStatus;
import org.atmosphere.vibe.platform.SimpleActions;
import org.atmosphere.vibe.platform.VoidAction;
import org.atmosphere.vibe.platform.server.ServerHttpExchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServerHttpExchange
implements ServerHttpExchange {
    protected final Actions<Object> chunkActions = new SimpleActions<Object>();
    protected final Actions<Void> endActions = new SimpleActions<Void>(new Actions.Options().once(true).memory(true));
    protected final Actions<Throwable> errorActions = new SimpleActions<Throwable>();
    protected final Actions<Void> closeActions = new SimpleActions<Void>(new Actions.Options().once(true).memory(true));
    private final Logger logger = LoggerFactory.getLogger(AbstractServerHttpExchange.class);
    private final Actions<Object> bodyActions = new SimpleActions<Object>(new Actions.Options().once(true).memory(true));
    private boolean read;
    private boolean readBody;
    private boolean ended;

    public AbstractServerHttpExchange() {
        this.endActions.add(new VoidAction(){

            @Override
            public void on() {
                AbstractServerHttpExchange.this.logger.trace("{}'s request has ended", (Object)AbstractServerHttpExchange.this);
            }
        });
        this.errorActions.add(new Action<Throwable>(){

            @Override
            public void on(Throwable throwable) {
                AbstractServerHttpExchange.this.logger.trace("{} has received a throwable {}", (Object)AbstractServerHttpExchange.this, (Object)throwable);
            }
        });
        this.closeActions.add(new VoidAction(){

            @Override
            public void on() {
                AbstractServerHttpExchange.this.logger.trace("{} has been closed", (Object)AbstractServerHttpExchange.this);
                AbstractServerHttpExchange.this.chunkActions.disable();
                AbstractServerHttpExchange.this.bodyActions.disable();
                AbstractServerHttpExchange.this.endActions.disable();
                AbstractServerHttpExchange.this.errorActions.disable();
            }
        });
    }

    @Override
    public String header(String name) {
        List<String> headers = this.headers(name);
        return headers != null && headers.size() > 0 ? headers.get(0) : null;
    }

    @Override
    public ServerHttpExchange read() {
        if (!this.read) {
            this.read = true;
            if (this.hasTextBody()) {
                this.readAsText();
            } else {
                this.readAsBinary();
            }
            if (this.ended) {
                this.endActions.add(new VoidAction(){

                    @Override
                    public void on() {
                        AbstractServerHttpExchange.this.closeActions.fire();
                    }
                });
            }
        }
        return this;
    }

    private boolean hasTextBody() {
        String contentType = this.header("content-type");
        return contentType != null && contentType.startsWith("text/");
    }

    public ServerHttpExchange chunkAction(Action action) {
        this.chunkActions.add(action);
        return this;
    }

    @Override
    public ServerHttpExchange endAction(Action<Void> action) {
        this.endActions.add(action);
        return this;
    }

    public ServerHttpExchange bodyAction(Action action) {
        if (!this.readBody) {
            this.readBody = true;
            if (this.hasTextBody()) {
                final StringBuilder body = new StringBuilder();
                this.chunkActions.add(new Action<Object>(){

                    @Override
                    public void on(Object data) {
                        body.append((String)data);
                    }
                });
                this.endActions.add(new VoidAction(){

                    @Override
                    public void on() {
                        AbstractServerHttpExchange.this.bodyActions.fire(body.toString());
                    }
                });
            } else {
                final ByteArrayOutputStream body = new ByteArrayOutputStream();
                this.chunkActions.add(new Action<Object>(){

                    @Override
                    public void on(Object data) {
                        ByteBuffer byteBuffer = (ByteBuffer)data;
                        byte[] bytes = new byte[byteBuffer.remaining()];
                        byteBuffer.get(bytes);
                        body.write(bytes, 0, bytes.length);
                    }
                });
                this.endActions.add(new VoidAction(){

                    @Override
                    public void on() {
                        AbstractServerHttpExchange.this.bodyActions.fire(ByteBuffer.wrap(body.toByteArray()));
                    }
                });
            }
        }
        this.bodyActions.add(action);
        return this;
    }

    protected abstract void readAsText();

    protected abstract void readAsBinary();

    @Override
    public final ServerHttpExchange setHeader(String name, Iterable<String> value) {
        Iterator<String> iterator = value.iterator();
        StringBuilder builder = new StringBuilder(iterator.next());
        while (iterator.hasNext()) {
            builder.append(", ").append(iterator.next());
        }
        return this.setHeader(name, builder.toString());
    }

    @Override
    public ServerHttpExchange setHeader(String name, String value) {
        this.logger.trace("{} sets a response header {} to {}", new Object[]{this, name, value});
        this.doSetHeader(name, value);
        return this;
    }

    protected abstract void doSetHeader(String var1, String var2);

    @Override
    public ServerHttpExchange write(String data) {
        this.logger.trace("{} sends a text chunk {}", (Object)this, (Object)data);
        this.doWrite(data);
        return this;
    }

    protected abstract void doWrite(String var1);

    @Override
    public ServerHttpExchange write(ByteBuffer byteBuffer) {
        this.logger.trace("{} sends a binary chunk {}", (Object)this, (Object)byteBuffer);
        this.doWrite(byteBuffer);
        return this;
    }

    protected abstract void doWrite(ByteBuffer var1);

    @Override
    public ServerHttpExchange end() {
        this.logger.trace("{} ends the response", (Object)this);
        if (!this.ended) {
            this.ended = true;
            this.doEnd();
            if (this.read) {
                this.closeActions.fire();
            }
        }
        return this;
    }

    protected abstract void doEnd();

    @Override
    public ServerHttpExchange end(String data) {
        return this.write(data).end();
    }

    @Override
    public ServerHttpExchange end(ByteBuffer data) {
        return this.write(data).end();
    }

    @Override
    public ServerHttpExchange setStatus(HttpStatus status) {
        this.logger.trace("{} sets a response status, {}", (Object)this, (Object)status);
        this.doSetStatus(status);
        return this;
    }

    protected abstract void doSetStatus(HttpStatus var1);

    @Override
    public ServerHttpExchange closeAction(Action<Void> action) {
        this.closeActions.add(action);
        return this;
    }

    @Override
    public ServerHttpExchange errorAction(Action<Throwable> action) {
        this.errorActions.add(action);
        return this;
    }
}

